<?php namespace Visiosoft\NetgsmModule\Listener;


use Visiosoft\ProfileModule\Profile\Events\SendEmptyPassword;

class SendEmptyPasswordNetGSM
{
    public function handle(SendEmptyPassword $event)
    {
        $netgsmController = app(\Visiosoft\NetgsmModule\Http\Controller\NetgsmController::class);

        $msg = html_entity_decode(
            trans('visiosoft.module.profile::message.empty_password_sms_message')
            . " "
            . $event->password()
            . " "
            . $this->getUrl() . '/login'
            , ENT_COMPAT, "UTF-8");
        $msg = rawurlencode($msg);
        $tel = $event->user()->gsm_phone;
        $netgsmController->sendSMS($msg, $tel);
    }

    public function getUrl() {
        if (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') {
            $link = "https";
        } else {
            $link = "http";
        }
        $link .= "://";
        $link .= $_SERVER['HTTP_HOST'];
        return $link;
    }
}
