<?php namespace Visiosoft\N11Module;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\N11Module\Order\Contract\OrderRepositoryInterface;
use Visiosoft\N11Module\Order\OrderRepository;
use Anomaly\Streams\Platform\Model\N11\N11OrdersEntryModel;
use Visiosoft\N11Module\Order\OrderModel;
use Visiosoft\N11Module\Integratedproduct\Contract\IntegratedproductRepositoryInterface;
use Visiosoft\N11Module\Integratedproduct\IntegratedproductRepository;
use Anomaly\Streams\Platform\Model\N11\N11IntegratedproductsEntryModel;
use Visiosoft\N11Module\Integratedproduct\IntegratedproductModel;
use Illuminate\Routing\Router;
use Visiosoft\AdvsModule\Adv\Event\EditedAd;
use Visiosoft\AdvsModule\Adv\Event\DeletedAd;

class N11ModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/n11/orders'           => 'Visiosoft\N11Module\Http\Controller\Admin\OrdersController@index',
        'admin/n11/orders/create'    => 'Visiosoft\N11Module\Http\Controller\Admin\OrdersController@create',
        'admin/n11/orders/edit/{id}' => 'Visiosoft\N11Module\Http\Controller\Admin\OrdersController@edit',
        'admin/n11'           => 'Visiosoft\N11Module\Http\Controller\Admin\IntegratedproductsController@index',
        'admin/n11/create'    => 'Visiosoft\N11Module\Http\Controller\Admin\IntegratedproductsController@create',
        'admin/n11/edit/{id}' => 'Visiosoft\N11Module\Http\Controller\Admin\IntegratedproductsController@edit',
        'admin/n11/create-product-on-n11/{id}' => 'Visiosoft\N11Module\Http\Controller\Admin\IntegratedproductsController@create',
        'admin/n11/select-product-to-be-integrated' => 'Visiosoft\N11Module\Http\Controller\Admin\IntegratedproductsController@select',
        'admin/get-top-categories' => 'Visiosoft\N11Module\Http\Controller\Admin\ApiRequestController@getTopLevelCategories',
        'admin/get-sub-categories/{category_id}' => 'Visiosoft\N11Module\Http\Controller\Admin\ApiRequestController@getSubLevelCategories',
        'admin/get-category-attributes/{category_id}' => 'Visiosoft\N11Module\Http\Controller\Admin\ApiRequestController@getCategoryAttributes',
        'admin/get-shipment-templates' => 'Visiosoft\N11Module\Http\Controller\Admin\ApiRequestController@getShipmentTemplates',
        'admin/n11/orders' => 'Visiosoft\N11Module\Http\Controller\Admin\OrdersController@index',
        // cron
        'admin/cron/n11/pullOrders' => 'Visiosoft\N11Module\Http\Controller\Admin\ApiRequestController@pullOrders',
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\N11Module\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\N11Module\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        EditedAd::class => [
            '\Visiosoft\N11Module\Integratedproduct\Listener\UpdateProduct@handleUpdate',
        ],
        DeletedAd::class => [
            '\Visiosoft\N11Module\Integratedproduct\Listener\DeleteProduct@handleDelete',
        ],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\N11Module\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        N11OrdersEntryModel::class => OrderModel::class,
        N11IntegratedproductsEntryModel::class => IntegratedproductModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        OrderRepositoryInterface::class => OrderRepository::class,
        IntegratedproductRepositoryInterface::class => IntegratedproductRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
