<?php namespace Visiosoft\N11Module\IntegratedProduct\Form;

use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\N11Module\Integratedproduct\IntegratedproductRepository;
use Visiosoft\N11Module\Http\Controller\Admin\ApiRequestController;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Anomaly\FilesModule\File\FileModel;
use Anomaly\Streams\Platform\Message\MessageBag;

class CreateProductOnN11FormHandler extends ApiRequestController
{
    public $entry;

    public function handle(CreateProductOnN11FormBuilder $builder, AdvModel $advModel, FileModel $fileModel, MessageBag $messages)
    {
        $productCreatedOnOurSite = $this->findProductJustCreatedOnOurSite($builder);
        
        if ($productCreatedOnOurSite->currency !== 'TRY') {
            $this->changeCurrency($productCreatedOnOurSite);
        }

        $imagesArrToBeSentToN11 = $this->prepareImagesForIntegration($advModel, $productCreatedOnOurSite);

        $dates = $this->prepareSaleRelatedDates($builder->getFormValue('saleStartDate'), $builder->getFormValue('saleEndDate'));

        $productInformation = [
            'productSellerCode' => $builder->getFormValue('productSellerCode'),
            'title' => $productCreatedOnOurSite->name,
            'subtitle' => $builder->getFormValue('productSubTitle'),
            'description' => $productCreatedOnOurSite->advs_desc,
            'category' => [
                'id' => $builder->getFormValue('categoryId'),
            ],
            'price' => $productCreatedOnOurSite->price,
            'currencyType' => '1',
            'images' => "",
            'productCondition' => $builder->getFormValue('useCase'),
            'preparingDay' => $builder->getFormValue('preparingDay'),
            'shipmentTemplate' => $builder->getFormValue('shipmentTemplateName'),
            'domestic' => $builder->getFormValue('productionPlace'),
            'attributes' => [
                'attribute' => json_decode($builder->getFormValue('categoryAttributes'), true)
            ],
            'stockItems' => [
                'stockItem' => [
                    [
                        'quantity' => $productCreatedOnOurSite->stock,
                        'gtin' => $builder->getFormValue('globalCommercialItemNumber'),
                        'n11CatalogId' => '',
                        'sellerStockCode' => $builder->getFormValue('sellerStockCode'),
                        'attributes' => '',
                        'optionPrice' => $productCreatedOnOurSite->price,
                        'images' => $imagesArrToBeSentToN11,
                    ]
                ]
            ],
            'unitInfo' => array(
                'unitType' => '',
                'unitWeight' => ''
            ),
            'maxPurchaseQuantity' => '',
            'groupAttribute' => '',
            'groupItemCode' => '',
            'itemName' => '',
            'saleStartDate' => $dates[0],
            'saleEndDate' => $dates[1],
            'productionDate' => '',
            'expirationDate' => '',
            'discount' => array(
                'startDate' => '',
                'endDate' => '',
                'type' => '',
                'value' => '',
            ),
            'sellerNote'=>''
        ];

        $response = $this->client->product->SaveProduct($productInformation);

        if ($response->result->status === 'success') {
            $this->saveIntegrationToDatabase($response->product, strval($productCreatedOnOurSite->id), $builder);
            $messages->success(trans('visiosoft.module.n11::message.success_integration'));
        } else if ($response->result->status === 'failure') {
            $messages->error($response->result->errorMessage);
        }
    }

    public function changeCurrency($productCreatedOnOurSite)
    {
        $settings = app(\Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface::class);
        $productCreatedOnOurSite->foreignCurrency($productCreatedOnOurSite->currency, $productCreatedOnOurSite->price,
            $productCreatedOnOurSite->id, $settings, false);
        $currencyList = (array)(json_decode($productCreatedOnOurSite->foreign_currencies));
        $productCreatedOnOurSite->price = $currencyList["TRY"];
    }

    public function prepareImagesForIntegration($advModel, $productCreatedOnOurSite) {
        $imagesArrToBeSentToN11 = ['image'=>[]];
        $productImagesArr = $advModel->getAdvimage(strval($productCreatedOnOurSite->id));

        foreach ($productImagesArr as $key => $image) {
            $imagesArrToBeSentToN11['image'][] = array(
                'url' => $image->make()->url(),
                'order' => ''. $key+1 .'',
            );
        }

        return $imagesArrToBeSentToN11;
    }

    public function prepareSaleRelatedDates($saleStartDate, $saleEndDate) {
        $dates = array();

        $formattedSaleStartDate = date("d/m/Y", strtotime($saleStartDate));
        $formattedSaleEndDate = date("d/m/Y", strtotime($saleEndDate));

        array_push($dates, $formattedSaleStartDate);
        array_push($dates, $formattedSaleEndDate);

        return $dates;
    }

    public function findProductJustCreatedOnOurSite($builder) {
        $this->entry = $builder->getFormEntry();
        $advs = app(AdvRepositoryInterface::class);
        $productCreatedOnOurSite = $advs->find($this->entry);

        return $productCreatedOnOurSite;
    }

    public function saveIntegrationToDatabase($integratedProduct, $entry, $builder) {
        $integratedProducts = app(IntegratedproductRepository::class);

        $integratedProduct = $integratedProducts->create([
            'product_id' => $entry,
            'barcode' => $integratedProduct->id,
            'n11_spesific_information' => json_encode([
                'productSellerCode' => $integratedProduct->productSellerCode,
                'globalCommercialItemNumber' => $integratedProduct->stockItems->stockItem->gtin,
                'categoryId' => $builder->getFormValue('categoryId'),
                'categorySlug' => strtolower($this->createSlug($builder->getFormValue('categoryName'))),
                'categoryAttributes' => $builder->getFormValue('categoryAttributes'),
                'sellerStockCode' => $integratedProduct->stockItems->stockItem->sellerStockCode,
                'productSubTitle' => $integratedProduct->subtitle,
                'useCase' => $builder->getFormValue('useCase'),
                'productionPlace' => $builder->getFormValue('productionPlace'),
                'preparingDay' => $builder->getFormValue('preparingDay'),
                'shipmentTemplateName' => $builder->getFormValue('shipmentTemplateName'),
                'saleStartDate' => $builder->getFormValue('saleStartDate'),
                'saleEndDate' => $builder->getFormValue('saleEndDate'),
            ]),
        ]);
    }

    public function createSlug($string)
    {
        $string = str_replace('ü','u',$string);
        $string = str_replace('Ü','U',$string);

        $string = str_replace('ğ','g',$string);
        $string = str_replace('Ğ','G',$string);

        $string = str_replace('ş','s',$string);
        $string = str_replace('Ş','S',$string);

        $string = str_replace('ç','c',$string);
        $string = str_replace('Ç','C',$string);

        $string = str_replace('ö','o',$string);
        $string = str_replace('Ö','O',$string);

        $string = str_replace('ı','i',$string);
        $string = str_replace('İ','I',$string);

        $slug=preg_replace('/[^A-Za-z0-9-]+/', '-', $string);

        return $slug;
    }
}
