<?php namespace Visiosoft\N11Module\Http\Controller\Admin\Services;

use Anomaly\Streams\Platform\Http\Controller\AdminController;

Class ProductService extends AdminController
{
    public $url;

	public function __construct()
    {
        $this->url = config('n11.service_url') . 'ProductService.wsdl';
    }

	public function getProductByProductId($client, $productId)
	{	
		return $client->sendRequest('GetProductByProductId', array('productId' => $productId));
	}
	
	public function getProductBySellerCode($client, $sellerCode)
	{	
		return $client->sendRequest('GetProductBySellerCode', array('sellerCode' => $sellerCode));
	}	

	public function getProductList($client, $pagination = array())
	{	
		return $client->sendRequest('GetProductList', array('pagingData' => $pagination));
	}

	public function SaveProduct($client, $product = array()) {
		return $client->sendRequest('SaveProduct', array('product' => $product));
	}

	public function deleteProductById($client, $productId)
	{	
		return $client->sendRequest('DeleteProductById', array('productId' => $productId));
	}

	public function deleteProductBySellerCode($client, $productSellerCode)
	{	
		return $client->sendRequest('DeleteProductBySellerCode', array('productSellerCode' => $productSellerCode));
	}	
}