<?php namespace Visiosoft\N11Module\Http\Controller\Admin\Helper;

class Request
{

	protected $apiKey;
	protected $apiPassword;
	protected $serviceUrl;
	protected $client = false;

	public function __construct($serviceUrl, $apiKey, $apiPassword)
	{
		$this->apiKey      = $apiKey;
		$this->apiPassword = $apiPassword;
		$this->serviceUrl  = $serviceUrl;
	}

	public function connectSoap()
	{
		try {
			$this->client = new \SoapClient($this->serviceUrl, array("trace" => 1, "exception" => false, 'cache_wsdl' => WSDL_CACHE_NONE));
			return true; 
		} catch (\Exception $e) {
			echo $e->getMessage();
		}
	}

	public function sendRequest($method, $data = array())
	{
		if (isset($data['auth'])) {
			unset($data['auth']);
		}

		try {
			return $this->client->$method(array_merge(array('auth' => array('appKey' => $this->apiKey, 'appSecret' => $this->apiPassword)), $data));
		} catch (\Exception $e) {
			echo $e->getMessage();
		}	
	}
}