<?php namespace Visiosoft\N11Module\Http\Controller\Admin\Helper;

class BaseCall
{
	protected $service = null;
	protected $request = null;
	protected $clientStatus = false;

	public function __construct($serviceName, $apiKey, $apiPassword)
	{
		$soapServiceName = "Visiosoft\N11Module\Http\Controller\Admin\Services\\" . $serviceName;
		$this->service = new $soapServiceName(); // i.e new CategoryService();
		$this->request = new Request($this->service->url , $apiKey, $apiPassword);
	}

	public function __call($methodName, $arguments)
	{
		if(!$this->clientStatus) {
			$this->clientStatus = $this->request->connectSoap();
		}

		if (!method_exists($this->service, $methodName)) {
			throw new \Exception(trans('visiosoft.module.n11::message.method_not_found'));
		}
		
		return call_user_func_array(array($this->service, $methodName), array_merge(array($this->request), $arguments));
	}
}
