<?php namespace Visiosoft\N11Module\Http\Controller\Admin;

use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\N11Module\Http\Controller\Admin\Client;
use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\Streams\Platform\Message\MessageBag;
use Visiosoft\N11Module\Integratedproduct\IntegratedproductRepository;
use Carbon\Carbon;
use Visiosoft\N11Module\Order\OrderRepository;

class ApiRequestController extends AdminController
{
    protected $client;
    public $messages;

    public function __construct(Client $client, MessageBag $messages)
    {
        $this->messages = $messages;
        $this->client = $client;
        $this->client->setApiKey(config('n11.api_key'));
        $this->client->setApiPassword(config('n11.api_password'));
    }

    // category services

    public function getTopLevelCategories()
    {
        $topLevelCategories = $this->client->category->getTopLevelCategories();
        return json_encode($topLevelCategories);
    }

    public function getSubLevelCategories($category_id)
    {
        $subLevelCategories = $this->client->category->getSubCategories($category_id);
        return json_encode($subLevelCategories);
    }

    public function getCategoryAttributes($category_id)
    {
        $categoryAttributes = $this->client->category->getCategoryAttributes($category_id);
        return json_encode($categoryAttributes);
    }

    public function getShipmentTemplates()
    {
        $shipmentTemplates = $this->client->shipment->getShipmentTemplateList();
        return json_encode($shipmentTemplates);
    }

    public function pullOrders()
    {
        $response = $this->client->order->orderList(
            [
                'status' => 'New',
                'sortForUpdateDate' => true,
                'pagingData' => [
                    'currentPage' => 0,
                    'pageSize'    => 100
                ]
            ]
        );

        if ($response->result->status === 'success') {
            $orderList = (array) $response->orderList;
            if (count($orderList) > 0) {
                $savedOrders = app(OrderRepository::class);
                $integratedProducts = app(IntegratedproductRepository::class);
    
                foreach ($orderList as $order) {
                    $response = $this->client->order->orderDetail($order->id);
    
                    if ( $integratedProduct = $integratedProducts->findBy('barcode', $response->orderDetail->id) ) {
                        if ( $savedOrders->findBy('order_number', $response->orderDetail->orderNumber) ) {
                            return;
                        } else {
                            $savedOrder = $savedOrders->create([
                                'order_number' => $response->orderDetail->orderNumber,
                                'quantity' => $response->orderDetail->itemList->item->quantity,
                                'price' => $response->orderDetail->itemList->item->price,
                                'product_id' => $integratedProduct['product_id'],                            
                            ]);

                            $this->messages->success('The latest version of your order list has been taken from N11.');
                            return redirect('/admin/n11/orders');
                        }
                    } else {
                        return;
                    }
                }
            } else {    
                return;
            }
        } else {
            $this->messages->error($response->result->errorMessage);
        }
    }
}