<?php namespace Visiosoft\N11Module\Integratedproduct\Listener;

use Visiosoft\N11Module\Integratedproduct\Form\CreateProductOnN11FormHandler;
use Visiosoft\AdvsModule\Adv\Event\EditedAd;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\N11Module\Integratedproduct\IntegratedproductRepository;

class UpdateProduct extends CreateProductOnN11FormHandler
{
    public function handleUpdate(EditedAd $updatedAdvModel)
    {
        $updatedProduct = $updatedAdvModel->getAdDetail();

        $integratedProducts = app(IntegratedproductRepository::class);

        // Detect whether the updated product is an integrated product.

        if ($integratedProductToBeUpdated = $integratedProducts->findBy('product_id', $updatedProduct->id)) {
            // Yes! Let's update the product on N11 as well.

            $informationSpecialToIntegration = json_decode($integratedProductToBeUpdated->n11_spesific_information);

            if ($updatedProduct->currency !== 'TRY') {
                $this->changeCurrency($updatedProduct);
            }

            $advModel = new AdvModel();

            $imagesArrToBeSentToN11 = $this->prepareImagesForIntegration($advModel, $updatedProduct);

            $dates = $this->prepareSaleRelatedDates($informationSpecialToIntegration->saleStartDate, $informationSpecialToIntegration->saleEndDate);

            $productInformation = [
                'productSellerCode' => $informationSpecialToIntegration->productSellerCode,
                'title' => $updatedProduct->name,
                'subtitle' => $informationSpecialToIntegration->productSubTitle,
                'description' => $updatedProduct->advs_desc,
                'category' => [
                    'id' => $informationSpecialToIntegration->categoryId,
                ],
                'price' => $updatedProduct->price,
                'currencyType' => '1',
                'images' => [
                    'image' => $imagesArrToBeSentToN11,
                ],
                'productCondition' => $informationSpecialToIntegration->useCase,
                'preparingDay' => $informationSpecialToIntegration->preparingDay,
                'shipmentTemplate' => $informationSpecialToIntegration->shipmentTemplateName,
                'domestic' => $informationSpecialToIntegration->productionPlace,
                'attributes' => [
                    'attribute' => json_decode($informationSpecialToIntegration->categoryAttributes, true)
                ],
                'stockItems' => [
                    'stockItem' => [
                        [
                            'quantity' => $updatedProduct->stock,
                            'gtin' => $informationSpecialToIntegration->globalCommercialItemNumber,
                            'n11CatalogId' => '',
                            'sellerStockCode' => $informationSpecialToIntegration->sellerStockCode,
                            'attributes' => '',
                            'optionPrice' => '',
                        ]
                    ]
                ],
                'unitInfo' => array(
                    'unitType' => '',
                    'unitWeight' => ''
                ),
                'maxPurchaseQuantity' => '',
                'groupAttribute' => '',
                'groupItemCode' => '',
                'itemName' => '',
                'saleStartDate' => $dates[0],
                'saleEndDate' => $dates[1],
                'productionDate' => '',
                'expirationDate' => '',
                'discount' => array(
                    'startDate' => '',
                    'endDate' => '',
                    'type' => '',
                    'value' => '',
                ),
            ];

            $response = $this->client->product->SaveProduct($productInformation);

            if ($response->result->status === 'success') {
                $this->messages->success(trans('visiosoft.module.n11::message.success_update_integration'));
            } else if ($response->result->status === 'failure') {
                $this->messages->error($response->result->errorMessage);
            }
        }
    }
}

