<?php namespace Visiosoft\N11Module\Integratedproduct\Listener;

use Visiosoft\AdvsModule\Adv\Event\DeletedAd;
use Visiosoft\N11Module\Integratedproduct\Listener\UpdateProduct;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\N11Module\Integratedproduct\IntegratedproductRepository;

class DeleteProduct extends UpdateProduct
{
    public function handleDelete(DeletedAd $deletedAdvModel)
    {
        $deletedProduct = $deletedAdvModel->getAdDetail();

        $integratedProducts = app(IntegratedproductRepository::class);

        if ($integratedProductToBeDeleted = $integratedProducts->findBy('product_id', $deletedProduct->id)) {
            $n11Id = $integratedProductToBeDeleted->barcode;            
            $response = $this->client->product->deleteProductById($n11Id);

            if ($response->result->status === 'success') {
                $this->messages->success(trans('visiosoft.module.n11::message.success_delete_integration'));
                $integratedProductToBeDeleted->delete();
            } else if ($response->result->status === 'failure') {
                $this->messages->error($response->result->errorMessage);
            }
        }
    }
}