<?php namespace Visiosoft\N11Module\Integratedproduct\Form;

use Anomaly\Streams\Platform\Ui\Form\FormBuilder;

class CreateProductOnN11FormBuilder extends FormBuilder
{
    /**
     * The form fields.
     *
     * @var array|string
     */
    protected $fields = [
        'productSellerCode' => [
            'label' => 'visiosoft.module.n11::field.productSellerCode.label',
            'instructions' => 'visiosoft.module.n11::field.productSellerCode.instructions',
            'type' => 'anomaly.field_type.text',
            'required' => true,
        ],
        'globalCommercialItemNumber' => [
            'label' => 'visiosoft.module.n11::field.globalCommercialItemNumber.label',
            'type' => 'anomaly.field_type.text',
        ],
        'category' => [
            'label' => 'visiosoft.module.n11::field.category.label',
            'instructions' => 'visiosoft.module.n11::field.category.instructions',
            'type' => 'anomaly.field_type.text',
            'required' => true,
            'config' => [
                'mode' => 'search',
            ],
        ],
        'categoryId' => [
            'required' => true,
            'type' => 'anomaly.field_type.text',
            'hidden' => true,            
        ],
        'categoryName' => [
            'required' => true,
            'type' => 'anomaly.field_type.text',
            'hidden' => true,            
        ],
        'categoryAttributes' => [
            'required' => false,
            'type' => 'anomaly.field_type.textarea',
            'hidden' => true,
        ],
        'sellerStockCode' => [
            'label' => 'visiosoft.module.n11::field.sellerStockCode.label',
            'type' => 'anomaly.field_type.text',
            'required' => true,
        ],
        'variantStockCode' => [
            'type' => 'anomaly.field_type.textarea',
            'hidden' => true,
        ],
        'productSubTitle' => [
            'label' => 'visiosoft.module.n11::field.productSubTitle.label',
            'type' => 'anomaly.field_type.text',
            'required' => true,
            'rules' => [
                'max:13',
            ],
            'required' => true,
        ],
        'useCase' => [
            'label' => 'visiosoft.module.n11::field.useCase.label',
            'type' => 'anomaly.field_type.select',
            "config" => [
                "options" => [true => 'visiosoft.module.n11::field.firstHand', 
                false => 'visiosoft.module.n11::field.secondHand'],
                "default_value" => true,
            ],         
            'required' => true,   
        ],
        'productionPlace' => [
            'label' => 'visiosoft.module.n11::field.productionPlace.label',
            'type' => 'anomaly.field_type.select',
            "config" => [
                "options" => [true => 'visiosoft.module.n11::field.domestic', 
                false => 'visiosoft.module.n11::field.foreign'],
                "default_value" => true,
            ],         
            'required' => true,   
        ],
        'preparingDay' => [
            'label' => 'visiosoft.module.n11::field.preparingDay.label',
            'instructions' => 'visiosoft.module.n11::field.preparingDay.instructions',   
            'type' => 'anomaly.field_type.integer',
            'required' => true,
        ],
        'shipmentTemplateName' => [
            'label' => 'visiosoft.module.n11::field.shipmentTemplateName.label',
            'instructions' => 'visiosoft.module.n11::field.shipmentTemplateName.instructions',   
            'type' => 'anomaly.field_type.select',
            'required' => true,
        ],
        'saleStartDate' => [
            'label' => 'visiosoft.module.n11::field.saleStartDate.label',
            'type' => 'anomaly.field_type.datetime',
            'required' => true,
        ],
        'saleEndDate' => [
            'label' => 'visiosoft.module.n11::field.saleEndDate.label',
            'type' => 'anomaly.field_type.datetime',
            'required' => true,
        ]
    ];

    /**
     * Additional validation rules.
     *
     * @var array|string
     */
    protected $rules = [
    ];

    /**
     * Fields to skip.
     *
     * @var array|string
     */
    protected $skips = [
    ];

    /**
     * The form actions.
     *
     * @var array|string
     */
    protected $actions = [
        'send' => [
            'text' => 'visiosoft.module.n11::button.send.name',
        ]
    ];

    /**
     * The form buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'cancel' => [
            'text' => 'visiosoft.module.n11::button.cancel.name'
        ]
    ];

    /**
     * The form options.
     *
     * @var array
     */
    protected $options = [
        'redirect' => 'admin/n11/',
        'success_message' => false,
    ];

    /**
     * The form sections.
     *
     * @var array
     */
    protected $sections = [];

    protected $handler = CreateProductOnN11FormHandler::class;

    /**
     * The form assets.
     *
     * @var array
     */
    protected $assets = [
        'scripts.js' => [
            'visiosoft.module.n11::js/modal.js',
            'visiosoft.module.n11::js/category.js',
            'visiosoft.module.n11::js/shipment-template.js',
            'visiosoft.module.n11::js/fuzzy.js',
        ],
        'styles.css' => [
            'visiosoft.module.n11::css/integrate-product.css',
        ],
    ];
}
