<?php namespace Visiosoft\N11Module\Http\Controller\Admin\Helper;

class GateWay
{
	public $apiKey;
	public $apiPassword;
	protected $allowedServices = array( 
		'city'            => 'CityService', 
		'shipmentcompany' => 'ShipmentCompanyService',
		'shipment'        => 'ShipmentService',
		'category'        => 'CategoryService',
		'product'         => 'ProductService',
		'selling'         => 'ProductSellingService',
		'stock'           => 'ProductStockService',
		'order'           => 'OrderService',
		'webhook'         => 'WebHookService',
	);

    public function __get($name)
    {
		if (!isset($this->allowedServices[$name])) {
			throw new \Exception(trans('visiosoft.module.n11::message.invalid_service_name'));
		}

		if (isset($this->$name)) {
			return $this->$name;
		}
		
		$this->$name = new BaseCall($this->allowedServices[$name], $this->apiKey, $this->apiPassword);
		return $this->$name;
    }
}
