$(document).ready(function(){
    getCategories('get-top-categories');

    $("body").on("click", "a.cat-name", handleTopCategorySelect);
    $("body").on("change", "select.sub-category-select", handleSubCategorySelect);

    function getCategories(categoryHierarchy, parentCategoryId = null) {
        let url = `/admin/${categoryHierarchy}` + (parentCategoryId ? `/${parentCategoryId}` : '');
        $.ajax({
            url: url,
            dataType: "json",
            success: function(resultObject) {
                if (resultObject.result.status == "success") {
                    let categoryList;
                    if (parentCategoryId) {
                        if (resultObject.category.hasOwnProperty('subCategoryList')) {
                            categoryList = resultObject.category.subCategoryList.subCategory;
                        } else {
                            $("#categoryId").attr('value', resultObject.category.id);
                            $("#categoryName").attr('value', resultObject.category.name);
                            getCategoryAttributes(resultObject.category.id);
                        }                        
                    } else {
                        categoryList = resultObject.categoryList.category;
                    }                       
                    reStructureForm(parentCategoryId, categoryList);               
                }
            }
        });
    }

    function reStructureForm(parentCategoryId, categoryList) {
        let categoryInputField;
        let matchedCategories;

        if (parentCategoryId === null) {
            categoryInputField = $("#category");
            matchedCategories = $(`<div class="list-group matched-categories" id="matched_categories"></div>`);
            categoryInputField.after(matchedCategories);
        } else {     
            if (categoryList) {
                categorySelectField = $(`
                    <select name="category_${parentCategoryId}" class="custom-select form-control sub-category-select"
                    data-field="useCase" data-field_name="useCase" data-provides="anomaly.field_type.select"
                    id="category_${parentCategoryId}" required>
                        <option selected>Please select a sub category</option>
                    </select>
                `);

                categoryList.forEach(function(item, index, array) {
                    categorySelectField.append(`
                        <option class="cat-name" value="${item.id}">${item.name}</option>
                    `);
                });

                let subCategoryInputWrapper = $(`
                    <div class="input-wrapper">                    
                        <div class="lds-ellipsis" id="categoryAttributes_loading">
                            <div></div>
                            <div></div>
                            <div></div>
                            <div></div>
                        </div>                    
                    </div>            
                `);
                
                subCategoryInputWrapper.prepend(categorySelectField);
                $("div.category-field").append(subCategoryInputWrapper);
            }       

            return;
        }        

        listCategories(categoryInputField, matchedCategories, categoryList);
    }

    function listCategories(categoryInputField, matchedCategories, categoryList) {    
        categoryInputField.keyup(function() {
            matchedCategories.show();
            let currentInput = categoryInputField.val();
            var options = {
                pre: '<', 
                post: '>', 
                extract: function(el) { return el.name; }
            };
    
            let results = fuzzy.filter(currentInput, categoryList, options);
            let matches = results.map(function(el) { return el.original; });
    
            extraFilteredMatches = matches.filter(function(item, index, array) {            
                $result = item.name.toLowerCase().indexOf(`${categoryInputField.val().toLowerCase()}`);
                if ($result !== 0) {
                    return false;
                } else {
                    return true;
                }
            });
    
            matchedCategories.html("");    
            extraFilteredMatches.forEach(function(item, index, array) {
                matchedCategories.append(`
                    <a href="#" id="${item.id}" class="list-group-item list-group-item-action category-option cat-name">${item.name}</a>
                `);
            });
        });
    
        categoryInputField.blur(function(event) {
            if (!($(event.relatedTarget).attr('class') == "list-group-item list-group-item-action category-option cat-name")) {
                matchedCategories.html(""); 
                matchedCategories.hide();
            }
        });       
    }

    function handleTopCategorySelect(event) {
        event.preventDefault();

        let toBeDeletedInputWrappers = $(event.target).parent().parent().nextAll('.input-wrapper');
        toBeDeletedInputWrappers.each(function() {
            $(this).remove();
        });

        let matchedCategories = $(event.target).parent();
        let categoryInputField = $(event.target).parent().prev();
        categoryInputField.val($(this).attr('id') + ' - ' + $(this).text());
        matchedCategories.html("");
        matchedCategories.hide();
        getCategories('get-sub-categories', $(this).attr('id'));
    }

    function handleSubCategorySelect(event) {
        let toBeDeletedInputWrappers = $(event.target).parent().nextAll('.input-wrapper');
        toBeDeletedInputWrappers.each(function() {
            $(this).remove();
        });

        let optionSelected = $("option:selected", this);
        getCategories('get-sub-categories', this.value);
    }

    function getCategoryAttributes(categoryId) {
        $.ajax({
            url: `/admin/get-category-attributes/${categoryId}`,
            dataType: "json",
            success: function(resultObject) {
                console.log(resultObject);
                if (resultObject.result.status === "success") {
                    arrangeAndHandleAttributeList(resultObject.category);
                }
            }
        });        
    }

    function arrangeAndHandleAttributeList(category) {
        function compareNecessaryStatus(a, b) {
            if (a.mandatory > b.mandatory) return -1;
            if (a.mandatory == b.mandatory) return 0;
            if (a.mandatory < b.mandatory) return 1;
        }

        if ($.isArray(category.attributeList.attribute)) {
            category.attributeList.attribute.sort(compareNecessaryStatus);
            for (let categoryAttribute of category.attributeList.attribute) {
                populateFormBody(categoryAttribute); 
            }
        } else {
            populateFormBody(category.attributeList.attribute);
        }

        function populateFormBody(categoryAttribute) {
            let options = ``;
            if (Array.isArray(categoryAttribute.valueList.value)) {
                for (let value of categoryAttribute.valueList.value) {
                    options += `
                    <option value="${value.name}">${value.name}</option>
                    `;
                }
            } else {
                options = `<option value="${categoryAttribute.valueList.value.name}">${categoryAttribute.valueList.value.name}</option>`;
            }
            document.getElementById('category_attributes_row').innerHTML += `
            <div class="col-6 p-1 text-center">
                <label for="cars"><b>${categoryAttribute.name}</b><span class="require-symbol">${categoryAttribute.mandatory ? ' *' : ''}</span></label>
                <select class="form-control" id="${categoryAttribute.id}" name="${categoryAttribute.name}" ${categoryAttribute.mandatory ? 'required' : ''}>
                    <option selected ${categoryAttribute.mandatory ? 'disabled' : ''} value="">Open this select menu</option>`
                +

                options

                +

                `</select>
            </div>`;
        }
        $('#categoryAttributesModal').modal('show');        
    }
});


