<?php namespace Visiosoft\MotorcycleTheme\Overrides;

use Anomaly\FileFieldType\FileFieldType;
use Visiosoft\MediaFieldType\MediaFieldType;
use Anomaly\FilesModule\File\FileModel;
use Anomaly\Streams\Platform\Ui\Table\TableBuilder;
use Illuminate\Database\Eloquent\Builder;

class ValueTableBuilder extends TableBuilder
{

    protected $uploaded = [];

    protected $fieldType = null;

    protected $model = FileModel::class;

    protected $columns = [
        'path' => '{entry.path}',

    ];

    protected $buttons = [
        'window' => [
            'text' => '',
            'icon' => 'fa fa-eye',
            'type' => 'light',
            'data-id' => 'entry.id',
            'class' => 'col-4 text-dark d-flex align-items-center justify-content-center',
            'attributes' => [
                'id' => 'vedat',
                'onclick' => 'setMain(event, {entry.id})'
            ],
        ],
        'rotate' => [
            'target' => '_blank',
            'icon' => 'fa fa-sync-alt fa-refresh',
            'type' => 'light',
            'text' => '',
            'class' => 'col-4 text-dark d-flex align-items-center justify-content-center',
            'attributes' => [
                'id' => 'rotateImage',
                'onclick' => 'rotateImage(event, {entry.id})',
            ],
        ],
        'deleteImage' => [
            'target' => '_blank',
            'icon' => 'fa fa-trash',
            'type' => 'light',
            'text' => '',
            'class' => 'col-4 deleteImage text-dark d-flex align-items-center justify-content-center',
            'attributes' => [
                'onclick' => 'deleteImage(event, {entry.id})',
                'id' => 'deleteImage',
            ],
        ],
    ];

    protected $options = [
        'limit' => 9999,
        'show_headers' => false,
        'sortable_headers' => false,
        'no_results_message' => 'visiosoft.field_type.media::message.no_files_selected',
        'table_view' => 'visiosoft.field_type.media::table/table'
    ];

    protected $assets = [
        'styles.css' => [
            'visiosoft.field_type.media::less/input.less',
        ],
    ];

    public function onQuerying(Builder $query)
    {
        $uploaded = $this->getUploaded();

        if ($fieldType = $this->getFieldType()) {

            $entry = $fieldType->getEntry();
            $table = $fieldType->getPivotTableName();

            if ($entry->getId() && !$uploaded) {
                $query->join($table, $table . '.file_id', '=', 'files_files.id');
                $query->where($table . '.entry_id', $entry->getId());
                $query->orderBy($table . '.sort_order', 'ASC');
            } else {
                $query->whereIn('id', $uploaded ?: [0]);
            }
        } else {

            $query->whereIn('id', $uploaded ?: [0]);
        }
    }

    public function getFieldType()
    {
        return $this->fieldType;
    }

    public function setFieldType(MediaFieldType $fieldType)
    {
        $this->fieldType = $fieldType;

        return $this;
    }

    public function getUploaded()
    {
        return $this->uploaded;
    }

    public function setUploaded($uploaded)
    {
        $this->uploaded = $uploaded;

        return $this;
    }

    public function setTableEntries(\Illuminate\Support\Collection $entries)
    {
        if (!$this->getFieldType()) {
            $entries = $entries->sort(
                function ($a, $b) {
                    return array_search($a->id, $this->getUploaded()) - array_search($b->id, $this->getUploaded());
                }
            );
        }

        return parent::setTableEntries($entries);
    }
}
