<?php namespace Visiosoft\MotorcycleTheme;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Illuminate\Support\Facades\Cookie;
use Visiosoft\MotorcycleTheme\Overrides\ValueTableBuilder;

class MotorcycleThemeServiceProvider extends AddonServiceProvider
{
    protected $plugins = [
        MotorcycleThemePlugin::class
    ];

    protected $aliases = [
        "Visiosoft\MediaFieldType\Table\ValueTableBuilder" => ValueTableBuilder::class
    ];


    protected $routes = [
        'ajax/getChooseStyleAdv'  => [
            'as' => 'getChooseStyleAdv',
            'uses' => 'Visiosoft\MotorcycleTheme\Http\Controller\MotorcycleThemeController@getChooseStyleAdv'
        ],
    ];

    public function boot(){
        if (request()->choose_style == '1'){
            $cf = 'cf_' . setting_value('visiosoft.theme.motorcycle::choose_style_cf');
            Cookie::queue(Cookie::make('chooseStyle', request()->$cf,259200));
        }
    }
}
