function optionValue(name, id, chooseText) {
    return `<option ${chooseText ? 'disabled selected ' : '' } value="${id}">${ chooseText ? chooseTextTrans : name}</option>`;
}

$(".cs-button").click(function() {
    if ($(this).attr("id")!='goPreview'){
        $("html, body").animate({ scrollTop: 0 }, "slow");
    }
});

$('#nextbtn1 , .prog-cf' ).on('click', function(){
    let catIds = [];
    for (var i = 1; i <= 9; i++) {
        var catSelect = $('#cat' + i + '_select').val();
        catIds.push(catSelect);
    }

    var parts = window.location.pathname.split('/');
    var advId = parts.pop();

    $.ajax({
        type: 'POST',
        url: '/ajax/get-cf-inputs',
        data: {
            "catIds" : catIds,
            "advId" :advId
        },
        beforeSend: function() {
                $("#overlay").fadeIn(700);
        },
        success: function (data) {
            $('#cf-ajax').html(data);
        }
    })
        .done(function() {
            $("#overlay").fadeOut(700);
    });
})

function fillcatsInput(cat, catId=null){
    var level = cat.slice(-1);

    var catData = $("#cat" +level+ "_select").val() ?  parseInt($("#cat" +level+ "_select").val()) : catId  ;
    var categoryInput = $("#cat" + (parseInt(level)+1) + "_select");

    categoryInput.attr('disabled',true).empty();
    $.ajax({
        type: 'POST',
        url: '/class/ajaxCategory',
        data: {
            "level": level,
            "cat": catData
        },
        success: function (data) {
            if (data.length == 0){
                for (let i=1; i<10; i++){
                    $("#cat" + (parseInt(level)+i) + "_select").hide();
                }
            }else{
                categoryInput.attr('disabled',false);
                fillcatsInput("cat" + (parseInt(level)+1) ,data[0].id);
                if (categoryInput.is(':hidden')) {
                    categoryInput.show();
                }
                if (categoryInput.attr("id") != 'cat2_select') {
                    categoryInput.append(optionValue('---', '', chooseTextTrans));
                }
                $.each(data, function (index, value) {
                    categoryInput.append(optionValue(value.name, value.id))
                })
            }
        }
    });
}

$(document).ready(function () {
    const catSelects = ["cat1", "cat2", "cat3", "cat4"];
    for (let cat of catSelects) {
        $(`#${cat}_select`).on('change', function () {
            fillcatsInput(cat);
        });
    }
    fillcatsInput('cat1');
});


