<?php namespace Visiosoft\MotorcycleTheme\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;

class MotorcycleThemeController extends PublicController
{
    public function getChooseStyleAdv(AdvRepositoryInterface $advRepository)
    {
        $limit = setting_value('visiosoft.theme.motorcycle::choose_style_limit');

        $cf = 'cf_' . setting_value('visiosoft.theme.motorcycle::choose_style_cf');

        $styledAdvs = $advRepository->searchAdvs(
            'list',[$cf => request()->cookie('choose_style')] , [], null, null, null, false)->limit(round(($limit*6)/10))->get();

        if ($styledAdvs->count < setting_value('visiosoft.theme.motorcycle::choose_style_limit')) {
            $ids = $styledAdvs->pluck('id');
            $otherAdvs = $advRepository->newQuery()
                ->whereNotIn('advs_advs.id', $ids)
                ->where('status', '=', 'approved')
                ->where('slug', '!=', '')
                ->limit($limit - $styledAdvs->count)->get();
            $styledAdvs = $styledAdvs->merge($otherAdvs);
        }
        return $this->view->make('visiosoft.theme.motorcycle::partials.choose-style-card',compact('styledAdvs'));
    }
}
