phoneMask("input[name='adress_gsm_phone']")

$('.add-ajax-address').on('click', function () {
    resetForm();

    //Set Default Country And List City
    $('select[name="country"]').val(default_country)
    if (default_country != "") {
        var cat = default_country;
        var level = 1;
        var name = 'city';
        Locations(cat, level, name);
    }

})

$("#cart-address").submit(function (e) {

    e.preventDefault(); // avoid to execute the actual submit of the form.
    var form = $(this);
    var url = form.attr('action');

    $.ajax({
        type: "POST",
        url: url,
        data: form.serialize(), // serializes the form's elements.
        success: function (response) {
            if (response.status == "success") {
                $('input[name="bill_address"]').removeAttr('selected');
                var option = '<option value="' + response.data.id + '" selected>' + response.data.adress_name + '</option>';
                var label = `<label class="billing-display-values" for="adress-${response.data.id}">
                            <input type="radio" id="adress-${response.data.id}"
                                   name="bill_address"
                                   value="${response.data.id}"
                                   selected
                                   class="radio-input mr-2">
                            ${response.data.adress_name}
                        </label>`;
                $('#my-adress').append(label);
                $('#addAddress2').modal('hide');
                resetForm();
            } else if (response.status == "updated") {
                $('.delivery_address option[value="' + response.data.id + '"]').html(response.data.adress_name)
                $('.bill_address option[value="' + response.data.id + '"]').html(response.data.adress_name)
                $('#addAddress2').modal('hide');
                resetForm();
            } else {
                alert(response.msg)
            }
        }
    });
});



$(document).ready(function () {

    var default_address = $('input[name="bill_address"]');
    if (default_address.val() == null) {
        $('#addAddress2').modal('show')
        //Set Default Country And List City
        $('select[name="country"]').val(default_country)
        if (default_country != "") {
            var cat = default_country;
            var level = 1;
            var name = 'city';
            Locations(cat, level, name);
        }
    } else {
        // Show the edit button
        $('.edit-this-address').show();
    }

});

function resetForm() {
    $("#cart-address").trigger("reset");
    $("#cart-address").find("textarea").html('');
    $('select[name="district"]').html('')

}


$('#contractBtn').on('click', () => {
    let cart = $('input[name="cart"]').val(),
        page = $('input[name="refund_page"]').val(),
        delivery_address = $('select[name="delivery_address"]').val(),
        bill_address = $('select[name="bill_address"]').val(),
        pay_type = $('select[name="pay_type"] option:selected').text();

    crudAjax({
        'cart': cart,
        'page': page,
        'delivery_address': delivery_address,
        'bill_address': bill_address,
        'pay_type': pay_type,
    }, `/contract-page`, 'GET', (callback) => {
        $('#contractModal .modal-body').html('');
    }).then((callback) => {
        $.each(callback ,function (key, value) {
            $('#contractModal .modal-body').append(
                `<div class="accordion" id="accordionExample">
                          <div class="card">
                            <div class="card-header" id="headingOne">
                              <h2 class="mb-0">
                                <button class="btn btn-link" type="button" data-toggle="collapse" data-target="#${key}" aria-expanded="true" aria-controls="${key}">
                                  ${value.store_name}
                                </button>
                              </h2>
                            </div>

                            <div id="${key}" class="collapse" aria-labelledby="headingOne" data-parent="#accordionExample">
                              <div class="card-body">
                                ${value.content}
                              </div>
                            </div>
                          </div>
                        </div>`
            )
        })
    })
})