<?php namespace Visiosoft\MotorcycleTheme\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;

class MotorcycleThemeController extends PublicController
{
    public function getChooseStyleAdv(AdvRepositoryInterface $advRepository)
    {
        $limit = setting_value('visiosoft.theme.motorcycle::choose_style_limit');

        $cf = 'cf_' . setting_value('visiosoft.theme.motorcycle::choose_style_cf');
        $selectedCfAdvsLimit = round(($limit*6)/10);

        $styledAdvs = $advRepository->searchAdvs(
            'list',[$cf => request()->cookie('chooseStyle')] , [], null, null, null, false)->inRandomOrder()->limit($selectedCfAdvsLimit)->get();

        if ($styledAdvs->count < $limit) {
            $ids = $styledAdvs->pluck('id');
            $otherAdvs = $advRepository->newQuery()
                ->whereNotIn('advs_advs.id', $ids)
                ->where('status', '=', 'approved')
                ->where('slug', '!=', '')
                ->whereDate('finish_at', '>=', date("Y-m-d H:i:s"))
                ->inRandomOrder()
                ->limit($limit - $styledAdvs->count)->get();
            $styledAdvs = $styledAdvs->merge($otherAdvs);
        }
        return $this->view->make('visiosoft.theme.motorcycle::partials.choose-style-card',compact('styledAdvs'));
    }
}
