$('.nav-burger i, .nav-mobile-fade, .close-mc').on('click', () => {
    $("body").toggleClass("overflow-hidden");
    $(".nav-mobile-log").toggleClass("transLog");
    $(".nav-mobile-fade").toggleClass("d-block");
})

if ($("body").width() <= "991") {
    $('.nav-drop-link').on('click', (e) => {
        const parentElement = $(e.currentTarget);
        const childElement = $(parentElement).find('.nav-drop-link-down')[0]
        const childIcon = $(parentElement).find('.nav-drop-link-button i')[0]
        $(childElement).toggleClass('d-block')
        $(childIcon).toggleClass('rotateArrow')
    })
}

$(window).scroll(function () {
    var scrolled_val = $(document).scrollTop().valueOf();
    var product_top_info = $(".product-top-info");
    var nav_web = $(".nav-web");
    if (scrolled_val > 150) {
        if (!product_top_info.hasClass('transTop'))
            product_top_info.addClass('transTop');
    } else {
        if (product_top_info.hasClass('transTop'))
            product_top_info.removeClass('transTop');
    }
    if (scrolled_val > 50) {
        nav_web.addClass('shadow-nav');
    } else {
        nav_web.removeClass('shadow-nav');
    }
});


$('.list-filter-button, .list-filter-modal-fade, .list-filter-modal-close').on('click', () => {
    $(".list-filter-modal").toggleClass("d-flex");
    $("body").toggleClass("overflow-hidden");
})

const clearButton = document.getElementById("clearButton");
const minPrice = document.getElementById("minimum");
const maxPrice = document.getElementById("maximum");

if ($('#choose-your-style').length > 0) {
    var categoryId = sessionStorage.getItem('category_id')
    if (categoryId) {
        $('#choose-your-style').addClass('d-none')
        $.ajax({
            type: 'get',
            url: '/ajax/get-advs-by-category/' + categoryId,
            success: function (response) {
                if (response.length > 0) {
                    $('#selected-cats').removeClass('d-none')
                }
                response.forEach(function (adv, index) {
                    $('#selected-cats > .selected').slick('slickAdd', `
                        <div>
                            <div>
                                <div class="selected-product">
                                    <a href="${adv.detail_url}" class="selected-product-area">
                                        <div class="selected-product-area-img">
                                            <img src="${adv.thumbnail}" alt="${adv.name}">
                                        </div>
                                        <div class="selected-product-area-info d-flex flex-column justify-content-between">
                                            <div class="selected-product-area-info-title">${adv.name}</div>
                                            <div class="d-flex justify-content-between align-items-center">
                                                <div class="selected-product-area-info-price">${adv.currency_price}</div>
                                                ${adv.city_name ? `
                                                    <div class="selected-product-area-info-location">
                                                        ${adv.city_name} <i class="fas fa-map-marker-alt"></i>
                                                    </div>` : ''
                    }
                                            </div>
                                        </div>
                                        <div class="selected-product-area-like">
                                            <i class="far fa-heart"></i>
                                        </div>
                                    </a>
                                </div>
                            </div>
                        </div>
                    `);
                })
            }
        })
    } else {
        $('#choose-your-style').removeClass('d-none')
        $('#selected-cats').addClass('d-none')
    }
}

function setSessionByCat(cat) {
    sessionStorage.setItem("category_id", cat);
}

$(clearButton).on('click', () => {
    minPrice.value = "";
    maxPrice.value = "";
});


$('.list-filter-price').on('click', () => {
    $(".list-filter-price i").toggleClass("list-arrow-transform");
    $(".list-filter-info").toggleClass("d-block");
})


$(window).on('click', (e) => {
    if (!$(e.target).closest('.list-filter-price, .list-filter-info').length) {
        $(".list-filter-info").removeClass("d-block");
        $(".list-filter-price i").removeClass("list-arrow-transform");
    }
})

$('.price-input-list').on('click', (e) => {
    const parentElement = $(e.currentTarget).parent().parent();
    const childElement = $(parentElement).find('.price-currency')[0]
    $(childElement).toggleClass('price-currency-color')
})
