function optionValue(name, id) {
    return `<option value="${id}">${name}</option>`;
}

$(".cs-button").click(function() {
    $("html, body").animate({ scrollTop: 0 }, "slow");
    return false;
});

$('#nextbtn1 , .prog-cf' ).on('click', function(){
    let catIds = [];
    for (var i = 1; i <= 3; i++) {
        var catSelect = $('#cat' + i + '_select').val();
        catIds.push(catSelect);
    }

    var parts = window.location.pathname.split('/');
    var advId = parts.pop();

    $.ajax({
        type: 'POST',
        url: '/ajax/get-cf-inputs',
        data: {
            "catIds" : catIds,
            "advId" :advId
        },
        beforeSend: function() {
                $("#overlay").fadeIn(700);
        },
        success: function (data) {
            $('#cf-ajax').html(data);
        }
    })
        .done(function() {
            $("#overlay").fadeOut(700);
    });
})

function getCat2(){
    var cat1 = $("#cat1_select").val();
    $('#cat2_select , #cat3_select').attr('disabled',true);
    $.ajax({
        type: 'POST',
        url: '/class/ajaxCategory',
        data: {
            "level": 1,
            "cat": cat1
        },
        success: function (data) {
            $('#cat2_select , #cat3_select').empty();
            if (data.length > 0){
                if ($('#cat2_select').is(':hidden')) {
                    $('#cat2_select').show();
                }
                $('#cat2_select').attr('disabled',false);
                getCat3(data[0].id);
                $.each(data, function (index, value) {
                    $('#cat2_select').append(optionValue(value.name, value.id));
                });
            }else{
                $('#cat2_select , #cat3_select').hide();
            }
        }
    });
}

function getCat3(cat2 = null){
    var cat2 = $("#cat2_select").val() ? parseInt($("#cat2_select").val()) : cat2 ;
    $('#cat3_select').attr('disabled',true).empty();
    $.ajax({
        type: 'POST',
        url: '/class/ajaxCategory',
        data: {
            "level": 2,
            "cat": cat2
        },
        success: function (data) {
            if (data.length == 0){
                $('#cat3_select').hide();
            }else{
                $('#cat3_select').attr('disabled',false);
                if ($('#cat3_select').is(':hidden')) {
                    $('#cat3_select').show();
                }
                $.each(data, function (index, value) {
                    $('#cat3_select').append(optionValue(value.name, value.id))
                })
            }
        }
    });
}

$(document).ready(function () {
    getCat2();
    $("#cat1_select").on('change', function (e) {
        getCat2();
    });
    $("#cat2_select").on('change', function (e) {
        getCat3();
    });

});


