<?php namespace Visiosoft\MotorcycleTheme\Seed;

use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Illuminate\Database\Seeder;


class RepeaterSeeder extends Seeder
{
    protected $streamRepository;
    protected $fieldsRepository;
    protected $assignmentsRepository;

    public function __construct(
        StreamRepositoryInterface $streamRepository,
        FieldRepositoryInterface $fieldsRepository,
        AssignmentRepositoryInterface $assignmentsRepository
    )
    {
        $this->streamRepository = $streamRepository;
        $this->fieldsRepository = $fieldsRepository;
        $this->assignmentsRepository = $assignmentsRepository;
    }

    public function run()
    {
        //Collect repeater
        $repeaters = [
            'banner' => [
                'content' => [
                    'name' => 'Banner',
                    'namespace' => 'repeater',
                    'slug' => 'banner',
                    'translatable' => true,
                ],
                'fields' => ['web_image', 'tablet_image', 'mobile_image']
            ],
        ];

        // Collect Repeater Fields
        $repeater_fields = [
            'web_image' => [
                'field_attributes' => [
                    'name' => 'Web Image',
                    'namespace' => 'repeater',
                    'slug' => 'web_image',
                    'type' => 'anomaly.field_type.file',
                    'locked' => 0,
                    'config' => [
                        'folders' => ['images'],
                        'mode' => 'upload',
                    ],
                ],
                'assignment_attributes' => [
                    'required' => true,
                ]
            ],
            'tablet_image' => [
                'field_attributes' => [
                    'name' => 'Tablet Image',
                    'namespace' => 'repeater',
                    'slug' => 'tablet_image',
                    'type' => 'anomaly.field_type.file',
                    'locked' => 0,
                    'config' => [
                        'folders' => ['images'],
                        'mode' => 'upload',
                    ],
                ],
                'assignment_attributes' => [
                    'required' => true,
                ]
            ],
            'mobile_image' => [
                'field_attributes' => [
                    'name' => 'Mobile Image',
                    'namespace' => 'repeater',
                    'slug' => 'mobile_image',
                    'type' => 'anomaly.field_type.file',
                    'locked' => 0,
                    'config' => [
                        'folders' => ['images'],
                        'mode' => 'upload',
                    ],
                ],
                'assignment_attributes' => [
                    'required' => true,
                ]
            ],
            'image_url' => [
                'field_attributes' => [
                    'name' => 'Image Url',
                    'namespace' => 'repeater',
                    'slug' => 'image_url',
                    'type' => 'anomaly.field_type.url',
                    'locked' => 0,
                ],
                'assignment_attributes' => [
                    'required' => false,
                ]
            ]
        ];

        foreach ($repeaters as $slug => $repeater) {
            if (!$repeater_stream = $this->streamRepository->findBySlugAndNamespace($slug, 'repeater')) {
                $repeater_stream = $this->streamRepository->create($repeater['content']);
            }

            foreach ($repeater_fields as $field_slug => $field_repeater) {
                if (!$field = $this->fieldsRepository->findBySlugAndNamespace($field_slug, 'repeater')) {
                    $field = $this->fieldsRepository->create($field_repeater['field_attributes']);
                }

                if (!$this->assignmentsRepository->findByStreamAndField($repeater_stream, $field)) {
                    $this->assignmentsRepository->create(
                        array_merge([
                            'stream' => $repeater_stream,
                            'field' => $field,
                        ], $field_repeater['assignment_attributes'])
                    );
                }
            }
        }
    }
}