<?php namespace Visiosoft\MotorcycleTheme\Seed;

use Anomaly\Streams\Platform\Model\Repeater\RepeaterDiscoverRepeaterEntryModel;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Anomaly\PagesModule\Page\Contract\PageRepositoryInterface;
use Anomaly\PagesModule\Type\Contract\TypeRepositoryInterface;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Illuminate\Database\Seeder;


class PagesSeeder extends Seeder
{

    protected $streamRepository;
    protected $fields;
    protected $assignments;
    protected $typeRepository;
    protected $pageRepository;

    public function __construct(
        StreamRepositoryInterface $streamRepository,
        FieldRepositoryInterface $fields,
        AssignmentRepositoryInterface $assignments,
        PageRepositoryInterface $pageRepository,
        TypeRepositoryInterface $typeRepository
    )
    {
        $this->streamRepository = $streamRepository;
        $this->fields = $fields;
        $this->assignments = $assignments;
        $this->typeRepository = $typeRepository;
        $this->pageRepository = $pageRepository;
    }


    protected $page_fields = [

    ];

    public function run()
    {
        if ($type = $this->typeRepository->findBySlug('default')) {
            $stream = $type->getEntryStream();

            foreach ($this->page_fields as $slug => $item) {

                if (!$field = $this->fields->findBySlugAndNamespace($slug, 'pages')) {
                    $field = $this->fields->create($item);
                }

                if (!$this->assignments->findByStreamAndField($stream, $field)) {
                    $this->assignments->create([
                        'stream' => $stream,
                        'field' => $field
                    ]);
                }

            }

        }

    }

}