<?php namespace Visiosoft\MotorcycleTheme;

use Anomaly\Streams\Platform\Addon\Plugin\Plugin;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;

class MotorcycleThemePlugin extends Plugin
{

    private $userRepository;

    private $customfieldRepository;
    public function __construct(
        UserRepositoryInterface $userRepository,
        CustomFieldRepositoryInterface $customFieldRepository
    )
    {
        $this->userRepository = $userRepository;
        $this->customfieldRepository = $customFieldRepository;
    }
    public function getFunctions(): array
    {
        return [
            new \Twig_SimpleFunction(
                'getAdvOwner',
                function ($id) {
                    $user = $this->userRepository->findBy("id",$id);
                    return $user;
                }
            ),
            new \Twig_SimpleFunction(
                'getCustomFieldById',
                function ($id) {
                    $customField = $this->customfieldRepository->findBy('id',$id);
                    if ($customField && $cfValues = $customField->cfvalues()->get()){
                        return ["id" => $customField->id, "name" => $customField->name, "values" => $cfValues->toArray()];
                    }
                    return null;
                }
            ),
        ];
    }
}
