<?php namespace Visiosoft\MotorcycleTheme;

use Anomaly\NavigationModule\Link\Contract\LinkRepositoryInterface;
use Anomaly\Streams\Platform\Addon\Plugin\Plugin;
use Anomaly\Streams\Platform\Ui\ControlPanel\Component\Navigation\Contract\NavigationLinkInterface;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;

class MotorcycleThemePlugin extends Plugin
{

    private $userRepository;

    private $customfieldRepository;

    private $linkRepo;
    public function __construct(
        UserRepositoryInterface $userRepository,
        CustomFieldRepositoryInterface $customFieldRepository,
        LinkRepositoryInterface $linkRepo
    )
    {
        $this->userRepository = $userRepository;
        $this->customfieldRepository = $customFieldRepository;
        $this->linkRepo = $linkRepo;
    }
    public function getFunctions(): array
    {
        return [
            new \Twig_SimpleFunction(
                'getAdvOwner',
                function ($id) {
                    $user = $this->userRepository->findBy("id",$id);
                    return $user;
                }
            ),
            new \Twig_SimpleFunction(
                'getCustomFieldById',
                function ($id) {
                    $customField = $this->customfieldRepository->findBy('id',$id);
                    if ($customField && $cfValues = $customField->cfvalues()->get()){
                        return ["id" => $customField->id, "name" => $customField->name, "values" => $cfValues->toArray()];
                    }
                    return null;
                }
            ),

            new \Twig_SimpleFunction(
                'getSubMenuByParentMenuId',
                function ($id) {
                    $submenus = $this->linkRepo->newQuery()
                        ->where('parent_id','=',null)
                        ->where('menu_id',$id)->get();

                    return $submenus;
                }
            ),
        ];
    }
}
