<?php namespace Visiosoft\MotorcycleTheme\Seed;

use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Illuminate\Database\Seeder;


class RepeaterSeeder extends Seeder
{
    protected $streamRepository;
    protected $fieldsRepository;
    protected $assignmentsRepository;

    public function __construct(
        StreamRepositoryInterface $streamRepository,
        FieldRepositoryInterface $fieldsRepository,
        AssignmentRepositoryInterface $assignmentsRepository
    )
    {
        $this->streamRepository = $streamRepository;
        $this->fieldsRepository = $fieldsRepository;
        $this->assignmentsRepository = $assignmentsRepository;
    }

    public function run()
    {
        //Collect repeater
        $repeaters = [
            'discover_repeater' => [
                'content' => [
                    'name' => '',
                    'namespace' => 'repeater',
                    'slug' => 'discover_repeater',
                    'translatable' => true,
                ],
                'fields' => ['info_text','image_url', 'discover_select', 'button_text']
            ]
        ];

        // Collect Repeater Fields
        $repeater_fields = [
            'image_url' => [
                'field_attributes' => [
                    'name' => 'Image URL',
                    'namespace' => 'repeater',
                    'slug' => 'image_url',
                    'type' => 'anomaly.field_type.file',
                    'locked' => 0,
                    'config' => [
                        'folders' => ['images'],
                        'mode' => 'upload',
                    ],
                ],
                'assignment_attributes' => [
                    'required' => true,
                    'translatable' => false,
                ]
            ],
            'info_text' => [
                'field_attributes' => [
                    'name' => 'Info Text',
                    'namespace' => 'repeater',
                    'slug' => 'info_text',
                    'type' => 'anomaly.field_type.text',
                    'locked' => 0,
                    'config' => [],
                ],
                'assignment_attributes' => [
                    'required' => true,
                    'translatable' => true,
                ]

            ],
            'button_text' => [
                'field_attributes' => [
                    'name' => 'Button Text',
                    'namespace' => 'repeater',
                    'slug' => 'button_text',
                    'type' => 'anomaly.field_type.text',
                    'locked' => 0,
                    'config' => [],
                ],
                'assignment_attributes' => [
                    'required' => true,
                    'translatable' => true,
                ]

            ],
            'discover_select' => [
                'field_attributes' => [
                    'name' => 'Discover Link',
                    'namespace' => 'repeater',
                    'slug' => 'discover_select',
                    'type' => 'anomaly.field_type.select',
                    'locked' => 0,
                    'config' => [
                        "options"       => [
                            ["advs/list?sort_by=popular " => "{{ trans('visiosoft.theme.motorcycle::field.popular_ads') }}", "advs/list?date=two_days" => "{{ trans('visiosoft.theme.motorcycle::field.last_two_day') }}"]
                        ],
                    ],
                ],
                'assignment_attributes' => [
                    'required' => true
                ]
            ]
        ];

        foreach ($repeaters as $slug => $repeater) {
            if (!$repeater_stream = $this->streamRepository->findBySlugAndNamespace($slug, 'repeater')) {
                $repeater_stream = $this->streamRepository->create($repeater['content']);
            }

            foreach ($repeater_fields as $field_slug => $field_repeater) {
                if (!$field = $this->fieldsRepository->findBySlugAndNamespace($field_slug, 'repeater')) {
                    $field = $this->fieldsRepository->create($field_repeater['field_attributes']);
                }

                if (!$this->assignmentsRepository->findByStreamAndField($repeater_stream, $field)) {
                    $this->assignmentsRepository->create(
                        array_merge([
                            'stream' => $repeater_stream,
                            'field' => $field,
                        ], $field_repeater['assignment_attributes'])
                    );
                }
            }
        }
    }

}