const MAX_IMAGE_SIZE = 5 * 1024 * 1024; // 5 MB

$(document).ready(function () {

    $('#plusBtn').click(function () {
        var value = parseInt($('#myInput').val());
        $('#myInput').val(value + 1);
    });

    $('#minusBtn').click(function () {
        var value = parseInt($('#myInput').val());
        $('#myInput').val(value - 1);
    });

    // Resim yükleme
    $("#file-input").change(function (event) {
        const file = event.target.files[0];
        const preview = $("#preview");
        const deleteButton = $("#delete-button");

        // Boyut kontrolü
        if (file.size > MAX_IMAGE_SIZE) {
            alert("Resim boyutu 5MB'tan fazla olamaz!");
            event.target.value = "";
            return;
        }

        // Dosya tipi kontrolü
        if (!file.type.match("image.*")) {
            alert("Lütfen sadece resim dosyası yükleyin!");
            event.target.value = "";
            return;
        }

        // Resim önizlemesi
        preview.css("display", "block");
        preview.attr("src", URL.createObjectURL(file));

        // Silme butonunu görünür hale getirme
        deleteButton.css("display", "block");
    });

    // Seçili resmi silme
    $("#delete-button").click(function () {
        const fileInput = $("#file-input");
        const preview = $("#preview");
        const deleteButton = $("#delete-button");

        fileInput.val("");
        preview.css("display", "none");
        preview.attr("src", "#");
        deleteButton.css("display", "none");
    });

    $("#billing-submit-button").click(function () {
        var street = $("#billing-street").val();
        var number = $("#billing-number").val();
        var box = $("#billing-box").val();
        var postal = $("#billing-postal").val();
        var city = $("#billing-city").val();

        var displayValues = street + "," + number + "," + box;
        displayValues += "<p>" + postal + " - " + city + "</p>";

        $("#billing-display-values").html(displayValues);
    });
});

$('.add-billing, #billing-close-button, .cs-close-icon, .billing-frame').on('click', () => {
    $(".default-billing").toggleClass("d-flex");
})


$('.prog-section-one, .prog-section-one-in-one').on('click', () => {
    $(".basic-info").removeClass("d-block");
    $("#basic-1").addClass("d-block");
    $(".progress-bar").removeClass("progress-2");
    $(".progress-bar").removeClass("progress-3");
    $(".progress-bar").removeClass("progress-4");
    $(".progress-bar").removeClass("progress-5");
    $(".progress-bar").removeClass("progress-6");
    $(".progress-bar").addClass("progress-1");
    $(".progress-bar span").text('1/6');
})

$('.prog-section-one-in-two').on('click', () => {
    $(".basic-info").removeClass("d-block");
    $("#basic-2").addClass("d-block");
})

$('.prog-section-one-in-three').on('click', () => {
    $(".basic-info").removeClass("d-block");
    $("#basic-3").addClass("d-block");
})

$('.prog-section-one-in-four').on('click', () => {
    $(".basic-info").removeClass("d-block");
    $("#basic-4").addClass("d-block");
})

$('.prog-section-two, prog-section-two-in-one').on('click', () => {
    $(".basic-info").removeClass("d-block");
    $("#detailed-1").addClass("d-block");
    $(".progress-bar").removeClass("progress-3");
    $(".progress-bar").removeClass("progress-4");
    $(".progress-bar").removeClass("progress-5");
    $(".progress-bar").removeClass("progress-6");
    $(".progress-bar").addClass("progress-2");
    $(".progress-bar span").text('2/6');
})

$('#billing-submit-button').on('click', () => {
    $("#billing-display-values").toggleClass("d-block");
    $("body").toggleClass("overflow-hidden");
    $(".default-billing").toggleClass("d-flex");
})


$('.buying-option').on('click', function () {
    $('.buying-option').removeClass('active-buying-option');

    $(this).addClass('active-buying-option');
});

$('.product-buying-option').on('click', function () {
    $('.product-buying-option').removeClass('active-buying-product');
    $(this).addClass('active-buying-product');
});

$('.cs-one-select-kind').on('click', function () {
    $('.cs-one-select-kind').removeClass('selected-kind');
    $(this).addClass('selected-kind');
    var value = $(this).attr('data-value')
    $('#cat1').val(value)
    $('#catSelectionStepForm').trigger('submit');
});

$('.prog-section-item').on('click', function () {
    $('.prog-sec-item').removeClass('prog-sec-main');
    $(this).find(".prog-sec-item").addClass('prog-sec-main');

    $('.prog-drop').removeClass('prog-active-drop');
    $(this).find('.prog-drop').addClass("prog-active-drop");
});

$('.prog-drop-main').on('click', function () {
    $('.prog-drop-main').removeClass('prog-drop-main-active');
    $(this).addClass('prog-drop-main-active');
});


$(document).ready(function () {
    $(".shipping-select").select2();
});

$('.nextbtn').on('click',function () {
    var btnId = $(this).data('id')
    nextAndPrevHandler('next',btnId)
})

$('.prevbtn').on('click',function () {
    var btnId = $(this).data('id')
    nextAndPrevHandler('prev',btnId)
})

function nextAndPrevSectionHandler(type){
    $('.prog-drop').removeClass('prog-active-drop');
    $('.prog-sec-item').removeClass('prog-sec-main');
    $(".basic-info").removeClass("d-block");

    $(".progress-bar").removeClass("progress-3");
    $(".progress-bar").removeClass("progress-4");
    $(".progress-bar").removeClass("progress-5");
    $(".progress-bar").removeClass("progress-6");

    if (type == 'next'){
        $("#detailed-1").addClass("d-block");
        $(".progress-bar").addClass("progress-2");
        $(".progress-bar span").text('2/6');
        $(".prog-section-two").addClass('prog-sec-main');
        $(".prog-section-two + .prog-drop ").addClass('prog-active-drop');
    }else{
        $("#basic-3").addClass("d-block");
        $(".progress-bar").removeClass("progress-2");
        $(".progress-bar").addClass("progress-1");
        $(".progress-bar span").text('1/6');
        $(".prog-section-one").addClass('prog-sec-main');
        $(".prog-section-one + .prog-drop ").addClass('prog-active-drop');
    }
}

$('#prevSectionBtn').on('click',function (){
    nextAndPrevSectionHandler('prev');
})

$('#sectionbtn').on('click',function () {
    nextAndPrevSectionHandler('next');
})

function nextAndPrevHandler(type,id) {

    var elementList = $('.prog-active-drop .prog-drop-main')
    var nextId = id + 1
    if (type == 'prev'){
        nextId = id - 1
    }

    elementList.each(function(index, element) {
        var classList = element.classList;

        if (classList.contains('prog-drop-main-active')) {
            classList.remove('prog-drop-main-active');
            if (type == 'prev'){
                elementList.eq(nextId - 1).addClass('prog-drop-main-active');
            }else {
                elementList.eq(id).addClass('prog-drop-main-active');
            }
        }
    });

    if ($(`#basic-${id}`).prop('classList').contains('d-block')){

        // find the required inputs under the current section
        var requiredInputs = $(`#basic-${id}`).find('input[required],textarea[required],select[required]');
        // find the inputs with max min attribute under the current section
        var maxMinInputs = $(`#basic-${id}`).find('input[max],input[min]');

        // check if rules are valid with these variables
        var allRequiredInputsFilled = true;
        var allMaxMinInputsValid = true;
        // validation messages
        var requiredInputsMessage = '';
        var maxMinInputsMessage = '';

        // check if all required inputs are filled
        requiredInputs.each(function(index, element) {
            if (element.value == ''){
                allRequiredInputsFilled = false;

                $(element).addClass('is-required');
                // for wysiwyg field type this class is not working
                // so we need to add this class to the parent element
                // todo this will be fixed in the next commit
                // if (element.classList.contains('hasEditor')) {
                //     $(element).parent().addClass('is-required');
                // }

                requiredInputsMessage = requiredMessage;
            }
        });
        // check if all max min inputs are valid
        maxMinInputs.each(function(index, element) {
            var value = element.value;
            var max = element.getAttribute('max');
            var min = element.getAttribute('min');
            if (value > max || value < min){
                allMaxMinInputsValid = false;
                maxMinInputsMessage = value > max ? maxMessage : minMessage;
                $(element).addClass('is-invalid-input');
            }
        });

        if (allRequiredInputsFilled){
            $(`#basic-${id}`).removeClass('d-block')
            $(`#basic-${nextId}`).addClass('d-block')
        } else {
            Swal.fire({
                icon: 'error',
                title: '',
                text: requiredInputsMessage + ' - ' + maxMinInputsMessage,
            })
        }
    }
}




