<?php namespace Visiosoft\MotorcycleTheme\Seed;

use Anomaly\Streams\Platform\Model\Repeater\RepeaterWebBannerFourEntryModel;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterWebBannerOneEntryModel;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterWebBannerThreeEntryModel;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterWebBannerTwoEntryModel;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Anomaly\PagesModule\Page\Contract\PageRepositoryInterface;
use Anomaly\PagesModule\Type\Contract\TypeRepositoryInterface;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Illuminate\Database\Seeder;


class PagesSeeder extends Seeder
{

    protected $streamRepository;
    protected $fields;
    protected $assignments;
    protected $typeRepository;
    protected $pageRepository;

    public function __construct(
        StreamRepositoryInterface $streamRepository,
        FieldRepositoryInterface $fields,
        AssignmentRepositoryInterface $assignments,
        PageRepositoryInterface $pageRepository,
        TypeRepositoryInterface $typeRepository
    )
    {
        $this->streamRepository = $streamRepository;
        $this->fields = $fields;
        $this->assignments = $assignments;
        $this->typeRepository = $typeRepository;
        $this->pageRepository = $pageRepository;
    }


    protected $page_fields = [
        'web_banner_one_repeater' => [
            'name' => 'Web Banner One',
            'slug' => 'web_banner_one_repeater',
            'type' => 'anomaly.field_type.repeater',
            'namespace' => 'pages',
            'locked' => 0,
            'config' => [
                'related' => RepeaterWebBannerOneEntryModel::class,
            ]
        ],
        'web_banner_two_repeater' => [
            'name' => 'Web Banner Two',
            'slug' => 'web_banner_two_repeater',
            'type' => 'anomaly.field_type.repeater',
            'namespace' => 'pages',
            'locked' => 0,
            'config' => [
                'related' => RepeaterWebBannerTwoEntryModel::class,
            ]
        ],
        'web_banner_three_repeater' => [
            'name' => 'Web Banner Three',
            'slug' => 'web_banner_three_repeater',
            'type' => 'anomaly.field_type.repeater',
            'namespace' => 'pages',
            'locked' => 0,
            'config' => [
                'related' => RepeaterWebBannerThreeEntryModel::class,
            ]
        ],
        'web_banner_four_repeater' => [
            'name' => 'Web Banner Four',
            'slug' => 'web_banner_four_repeater',
            'type' => 'anomaly.field_type.repeater',
            'namespace' => 'pages',
            'locked' => 0,
            'config' => [
                'related' => RepeaterWebBannerFourEntryModel::class,
            ]
        ],
    ];

    public function run()
    {
        if ($type = $this->typeRepository->findBySlug('default')) {
            $stream = $type->getEntryStream();

            foreach ($this->page_fields as $slug => $item) {

                if (!$field = $this->fields->findBySlugAndNamespace($slug, 'pages')) {
                    $field = $this->fields->create($item);
                }

                if (!$this->assignments->findByStreamAndField($stream, $field)) {
                    $this->assignments->create([
                        'stream' => $stream,
                        'field' => $field
                    ]);
                }

            }

        }

    }

}