<?php namespace Visiosoft\MotorcycleModule\Listeners;

use Anomaly\UsersModule\Role\Contract\RoleRepositoryInterface;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Illuminate\Support\Facades\Log;
use Monolog\Handler\StreamHandler;
use Monolog\Logger;
use Visiosoft\MotorcycleModule\Transport\Event\TransportChangeStatus;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Notification\MailTemplate;

class TransportChangeStatusNotification
{
    private $template;
    private $user;

    public function __construct(
        RoleRepositoryInterface $roleRepository,
        UserRepositoryInterface $user,
        TemplateRepositoryInterface $template
    )
    {
        $this->roleRepository = $roleRepository;
        $this->template = $template;
        $this->user = $user;
    }

    public function handle(TransportChangeStatus $event)
    {
        $transport = $event->getTransport();
        $status = $event->getStatus();


        if ($user = $this->user->find($transport->user_id)) {


            $mail_params = [
                'transport_id' => $transport->id,
                'transport_detail_url' => route('transport_records_detail', ['id' => $transport->id]),
                'status_name' => $status->name,
            ];

         //Send User
            try {
                if ($template = $this->template->findBySlug('transport_status_changed')) {
                    $user->notify(new MailTemplate($template->getTemplateForArray($mail_params)));
                }
            }catch (\Exception $e){
                $log = new Logger('mail');
                $log->pushHandler(new StreamHandler(storage_path('logs/mail.log')), Logger::ERROR);
                $log->error($e->getMessage());
            }

        }
    }
}
