<?php namespace Visiosoft\MotorcycleModule\Address;

use Visiosoft\MotorcycleModule\Address\Contract\AddressRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class AddressRepository extends EntryRepository implements AddressRepositoryInterface
{
    /**
     * The entry model.
     *
     * @var AddressModel
     */
    protected $model;

    /**
     * Create a new AddressRepository instance.
     *
     * @param AddressModel $model
     */
    public function __construct(AddressModel $model)
    {
        $this->model = $model;
    }

    public function createMultiple($addresses)
    {

       // create addresses
        $from = [
            'city_id' => $addresses['from_city'],
            'district_id' => $addresses['from_district'],
            'date' => $addresses['from_date']
        ];
        $to = [
            'city_id' => $addresses['to_city'],
            'district_id' => $addresses['to_district'],
            'date' => $addresses['to_date']
        ];
        return [$this->create($from)->id,$this->create($to)->id];
    }
}
