<?php namespace Visiosoft\MotorcycleModule\PriceOffer;

use Visiosoft\MotorcycleModule\PriceOffer\Contract\PriceOfferInterface;
use Anomaly\Streams\Platform\Model\Motorcycle\MotorcyclePriceOfferEntryModel;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class PriceOfferModel extends MotorcyclePriceOfferEntryModel implements PriceOfferInterface
{
    use HasFactory;

    /**
     * @return PriceOfferFactory
     */

    public function getAddress(){
        $data = [
            'city' => $this->deliveryPoint->city->name,
            'district' => $this->deliveryPoint->district->name,
        ];


        if ($this->deliveryPoint->neighborhood){
            $data['neighborhood'] = $this->deliveryPoint->neighborhood->name;
        }
        return $data;
    }



    public function getProduct(){
        $data = [
            'cat1' => $this->product->cat1->name,
            'cat2' => $this->product->cat2->name,
            'files' => $this->product->getImages(),
            'status' => $this->product->statusModel->name
        ];

        return $data;
    }

    protected static function newFactory()
    {
        return PriceOfferFactory::new();
    }
}
