<?php namespace Visiosoft\MotorcycleModule\Http\Controller\Admin;

use Anomaly\FilesModule\File\Contract\FileRepositoryInterface;
use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Anomaly\Streams\Platform\Entry\EntryModel;
use Anomaly\Streams\Platform\Image\Command\MakeImageInstance;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Iyzipay\Model\Status;
use Visiosoft\MotorcycleModule\Address\Contract\AddressRepositoryInterface;
use Visiosoft\MotorcycleModule\PriceOffer\Contract\PriceOfferRepositoryInterface;
use Visiosoft\MotorcycleModule\PriceOffer\Form\PriceOfferFormBuilder;
use Visiosoft\MotorcycleModule\PriceOffer\Table\PriceOfferTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\MotorcycleModule\Product\Contract\ProductRepositoryInterface;

class PriceOfferController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param PriceOfferTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(PriceOfferTableBuilder $table)
    {
        $table->setColumns(['photo' => [
            'value' => function (EntryInterface $entry, ProductRepositoryInterface $productRepo) {
                $product = $productRepo->newQuery()->with(['cat1', 'cat2'])->find($entry->product_id);
                $images = $product->getImages();
                $noImg = $this->dispatch(new MakeImageInstance('visiosoft.theme.base::images/no-image.png', 'img'))->url();
                if ($images) {
                    return "<img width='80px' src='" . $images[0] . "' >";
                } else {
                    return "<img width='80px' src='" . $noImg . "' >";

                }
            }
        ],
            'product' => [
                'value' => function (EntryModel $entry, ProductRepositoryInterface $productRepo) {
                    $product = $productRepo->newQuery()->with(['cat1', 'cat2'])->find($entry->product_id);
                    return "<span>" . $product->cat1->name . "-" . $product->cat2->name . "</span>";
                }
            ],
            'status' => [
                'value' => function (EntryModel $entry, ProductRepositoryInterface $productRepo) {
                    $product = $productRepo->newQuery()->with(['cat1', 'cat2'])->find($entry->product_id);
                    return "<span>" . $product->statusModel->name . "</span>";

                }
            ],
            'from' => [
                'value' => function (EntryModel $entry, AddressRepositoryInterface $addressRepo) {
                    $address = $addressRepo->newQuery()->find($entry->delivery_point_id);
                    return "<span>" . $address->getCityName() . "-" . $address->getDistrictName() . "</span>";
                }
            ],

            'user',
        ]);


        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param PriceOfferFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(PriceOfferFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param PriceOfferFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(PriceOfferFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function view($id, PriceOfferRepositoryInterface $offerRepo, UserRepositoryInterface $userRepo)
    {
        $offer = $offerRepo->newQuery()->find($id);
        //product
        $product = $offer->getProduct();

        //address
        $address = $offer->getAddress();

        //user
        $user = $userRepo->newQuery()->find($id);

        $offer = array_merge($address, $product);

        return $this->view->make('visiosoft.module.motorcycle::admin.show-offer', compact('offer', 'user'))->render();
    }
}
