function optionValue(name, id) {
    return `<option value="${id}">${name}</option>`;
}

function getCat2() {
    var cat1 = $("#cat1_select").val();
    var child_inputs = $('#cat2_select , #cat3_select');
    child_inputs.attr('disabled', true);
    $.ajax({
        type: 'POST',
        url: '/class/ajaxCategory',
        data: {
            "level": 1,
            "cat": cat1
        },
        success: function (data) {
            child_inputs.empty();
            if (data.length > 0) {
                if ($('#cat2_select').is(':hidden')) {
                    $('#cat2_select').show();
                }
                $('#cat2_select').attr('disabled', false);
                $.each(data, function (index, value) {
                    $('#cat2_select').append(optionValue(value.name, value.id));
                });
            } else {
                child_inputs.hide();
            }
        }
    });
}

$(document).ready(function () {
    getCat2();
    $("#cat1_select").on('change', function (e) {
        getCat2();
    });
});