<?php namespace Visiosoft\MotorcycleModule\Http\Controller;

use Anomaly\FilesModule\Folder\Contract\FolderRepositoryInterface;
use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Visiosoft\MotorcycleModule\Address\Contract\AddressRepositoryInterface;
use Visiosoft\MotorcycleModule\PriceOffer\Contract\PriceOfferRepositoryInterface;
use Visiosoft\MotorcycleModule\Product\Contract\ProductRepositoryInterface;
use Visiosoft\MotorcycleModule\Status\Contract\StatusRepositoryInterface;

class PriceOfferController extends PublicController
{
    private $addressRepo;

    private $productRepo;

    private $statusRepo;

    private $offerRepo;

    public function __construct(
        AddressRepositoryInterface    $addressRepo,
        ProductRepositoryInterface    $productRepo,
        StatusRepositoryInterface     $statusRepo,
        PriceOfferRepositoryInterface $priceOfferRepo
    )
    {
        $this->addressRepo = $addressRepo;
        $this->productRepo = $productRepo;
        $this->statusRepo = $statusRepo;
        $this->offerRepo = $priceOfferRepo;
        parent::__construct();
    }

    public function view()
    {
        $statuses = $this->statusRepo->newQuery()->where('enabled', 1)->where('type' ,'product_status')->get();
        return $this->view->make('visiosoft.module.motorcycle::offer/create', compact('statuses'))->render();
    }

    public function formcreate(Request $request)
    {
        $params = $request->toArray();
        $address = $this->addressRepo->create([
            'city_id' => $params['from_city'],
            'district_id' => $params['from_district'],
            'neighborhood_id' => $params['neighborhood'],
        ]);

        $product = $this->productRepo->create([
            'cat1_id' => $params['cat1'],
            'cat2_id' => $params['cat2'],
            'status' => $params['product_status'],
            'desc' => $params['product_desc'],
            'year' => $params['year'],
            'km' => $params['km']
        ]);

        $images = explode(",", $params['files']);
        array_shift($images);

        foreach ($images as $image) {
            DB::table('motorcycle_product_files')->insert([
                'entry_id' => $product->id,
                'file_id' => $image
            ]);
        }

        $this->offerRepo->create([
            'product_id' => $product->id,
            'delivery_point_id' => $address->id,
            'user_id' => Auth::id()
        ]);

        $this->messages->success(trans('visiosoft.module.motorcycle::message.record_success'));
        return $this->redirect->to('/');
    }
}
