<?php namespace Visiosoft\MotorcycleModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Visiosoft\MotorcycleModule\Address\Contract\AddressRepositoryInterface;
use Visiosoft\MotorcycleModule\Product\Contract\ProductRepositoryInterface;
use Visiosoft\MotorcycleModule\Status\Contract\StatusRepositoryInterface;
use Visiosoft\MotorcycleModule\Transport\Contract\TransportRepositoryInterface;

class TransportController extends PublicController
{
    private $addressRepo;
    private $productRepo;
    private $transportRepo;
    private $statusRepo;

    public function __construct(
        AddressRepositoryInterface   $addressRepo,
        ProductRepositoryInterface   $productRepo,
        TransportRepositoryInterface $transportRepo,
        StatusRepositoryInterface    $statusRepo
    )
    {
        $this->addressRepo = $addressRepo;
        $this->productRepo = $productRepo;
        $this->transportRepo = $transportRepo;
        $this->statusRepo = $statusRepo;
        parent::__construct();
    }

    public function view()
    {
        $statuses = $this->statusRepo->all();
        return $this->view->make('visiosoft.module.motorcycle::transport/create', compact('statuses'))->render();
    }

    public function formcreate(Request $request)
    {

        $params = $request->toArray();

        if ($params['from_date'] > $params['to_date']) {
            $this->messages->error(trans('visiosoft.module.motorcycle::message.fail_date'));
            return $this->redirect->back();
        }


        if ($this->transportRepo->findBy('user_id', Auth::id()) && $this->transportRepo->findBy('user_id', Auth::id())->count() > 5) {
            $this->messages->error(trans('visiosoft.module.motorcycle::message.phone_limit'));
            return $this->redirect->back();
        }

        $addresses = array_filter($params, function ($k) {
            return str_contains($k, 'from') || str_contains($k, 'to');
        }, ARRAY_FILTER_USE_KEY);


        $address = $this->addressRepo->createMultiple($addresses);

        $product = $this->productRepo->create([
            'cat1_id' => $params['cat1'],
            'cat2_id' => $params['cat2'],
            'status' => $params['product_status'],
            'desc' => $params['product_desc']
        ]);

        $images = explode(",", $params['files']);
        array_shift($images);

        foreach ($images as $image) {
            DB::table('motorcycle_product_files')->insert([
                'entry_id' => $product->id,
                'file_id' => $image
            ]);
        }

        $data = [
            'from_id' => $address[0],
            'to_id' => $address[1],
            'product_id' => $product->id,
            'user_id' => Auth::id(),
        ];

        $this->transportRepo->create($data);

        $this->messages->success(trans('visiosoft.module.motorcycle::message.record_success'));
        return $this->redirect->to('/');
    }
}
