<?php namespace Visiosoft\MotorcycleModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Entry\EntryModel;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\MotorcycleModule\Address\Contract\AddressRepositoryInterface;
use Visiosoft\MotorcycleModule\Product\Contract\ProductRepositoryInterface;
use Visiosoft\MotorcycleModule\Transport\Contract\TransportRepositoryInterface;
use Visiosoft\MotorcycleModule\Transport\Form\TransportFormBuilder;
use Visiosoft\MotorcycleModule\Transport\Table\TransportTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class TransportController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param TransportTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(TransportTableBuilder $table)
    {
        $table->setColumns([
           'from' => [
               'value' => function(EntryModel $entry, AddressRepositoryInterface $addressRepo){
                   $address = $addressRepo->newQuery()->find($entry->from_id);
                return "<span>"  .$address->getCityName().  "-"    .$address->getDistrictName().  "</span>";
               }
           ],
            'to' => [
                'value' => function(EntryModel $entry, AddressRepositoryInterface $addressRepo){
                    $address = $addressRepo->newQuery()->find($entry->to_id);
                    return "<span>"  .$address->getCityName().  "-"    .$address->getDistrictName().  "</span>";
                }
            ],
            'product' => [
                'value' => function (EntryModel $entry, ProductRepositoryInterface $productRepo) {
                $product = $productRepo->newQuery()->with(['cat1','cat2'])->find($entry->product_id);

                return "<span>"  .$product->cat1->name.  "-"    .$product->cat2->name.  "</span>";

                }
            ],
            'user'
        ]);


        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param TransportFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(TransportFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param TransportFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(TransportFormBuilder $form, $id)
    {
        return $form->render($id);
    }


    public function view($id, TransportRepositoryInterface $transportRepository,  UserRepositoryInterface $userRepo){

        $transport = $transportRepository->newQuery()->find($id);
        $addresses = $transport->getAddresses();

        foreach ($addresses as $key => $value) {
            $transport->$key = $value;
        }

        $product = $transport->getProduct();
        //user
        $user = $userRepo->newQuery()->where('id',$transport->user_id)->first();


        return $this->view->make('visiosoft.module.motorcycle::admin.show-transport', compact('transport','user', 'product'))->render();
    }
}



