<?php namespace Visiosoft\MotorcycleModule\Transport;

use Carbon\Carbon;
use Visiosoft\MotorcycleModule\Transport\Contract\TransportInterface;
use Anomaly\Streams\Platform\Model\Motorcycle\MotorcycleTransportEntryModel;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class TransportModel extends MotorcycleTransportEntryModel implements TransportInterface
{
    use HasFactory;

    /**
     * @return TransportFactory
     */

    public function getFromCityName(){
        return $this->from->city->name;
    }

    public function  getFromDistrictName(){
        return $this->from->district->name;
    }

    public function getToCityName(){
        return $this->to->city->name;
    }

    public function getToDistrictName(){
        return $this->to->district->name;
    }

    public function getToDate(){
        return Carbon::create($this->to->date)->format('d.m.Y');
    }

    public function getFromDate(){
        return Carbon::create($this->from->date)->format('d.m.Y');
    }

    public function getAddresses(){
        return [
            'from_city' => $this->getFromCityName(),
            'from_district' =>  $this->getFromDistrictName() ,
            'from_date' => $this->getFromDate(),
            'to_city' => $this->getToCityName(),
            'to_district' => $this->getToDistrictName(),
            'to_date' => $this->getToDate()
        ];
    }
    public function getProduct(){
        $data = [
            'cat1' => $this->product->cat1->name,
            'cat2' => $this->product->cat2->name,
            'files' => $this->product->getImages(),
            'status' => $this->product->statusModel->name,
            'year' => $this->product->year,
            'km' => $this->product->km,
            'desc'=> $this->product->desc,
            'files' => $this->product->getImages(),
        ];

        return $data;
    }
    protected static function newFactory()
    {
        return TransportFactory::new();
    }
}
