<?php namespace Visiosoft\MotorcycleModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Entry\EntryModel;
use Visiosoft\MotorcycleModule\Status\Form\StatusFormBuilder;
use Visiosoft\MotorcycleModule\Status\Table\StatusTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class StatusController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param StatusTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(StatusTableBuilder $table)
    {
        $table->setColumns([
            'status' => 'name',
            'enabled' => [
                'value' => function (EntryModel $entry) {
                    $icon = "fa fa-check";
                    if ($entry->enabled !== true) {
                        $icon = "fa fa-times";
                    }
                    return '<i class="' . $icon . '"></i>';
                }
            ],
        ]);
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param StatusFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(StatusFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param StatusFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(StatusFormBuilder $form, $id)
    {
        return $form->render($id);
    }
}
