function optionValue(name, id) {
    return `<option value="${id}">${name}</option>`;
}

function getCat2() {
    var cat1 = $("#cat1_select").val();
    var child_inputs = $('#cat2_select , #cat3_select');
    child_inputs.attr('disabled', true);
    $.ajax({
        type: 'POST',
        url: '/class/ajaxCategory',
        data: {
            "level": 1,
            "cat": cat1
        },
        success: function (data) {
            child_inputs.empty();
            if (data.length > 0) {
                if ($('#cat2_select').is(':hidden')) {
                    $('#cat2_select').show();
                }
                $('#cat2_select').attr('disabled', false);
                $.each(data, function (index, value) {
                    $('#cat2_select').append(optionValue(value.name, value.id));
                });
            } else {
                child_inputs.hide();
            }
        }
    });
}

$(document).ready(function () {
    getCat2();
    $("#cat1_select").on('change', function (e) {
        getCat2();
    });


    $(() => {
        const $statusButtons = $('.status_button');
        const $productStatusInput = $("input[name=product_status]");
        const $disableModal = $('.status_disable_modal');
        const $requireError = $('.require_error');
        const $statusLabel = $('#status_section');

        $statusButtons.on('click', function (e) {
            if ($(this).hasClass('disable')){
                $disableModal.fadeIn(300).css("display", "flex");
            }else{
                $statusButtons.removeClass('active');

                const value = $(this).attr('data-value');

                $(this).addClass('active');
                $productStatusInput.val(value);
            }
        });

        $statusButtons.on('click', () => {
            if($productStatusInput.val()){
                $('.step_1').addClass('d-none');
                $('.step_2').removeClass('d-none');
            }else{
                $statusLabel.addClass('pb-50');
                $requireError.fadeIn(1000, function() {
                    setTimeout(function() {
                        $requireError.fadeOut(1000);
                        $statusLabel.removeClass('pb-50');
                    }, 3000);
                });
            }
        })

        $('.status_disable_modal .close').on('click', () => {
            $disableModal.fadeOut(300);
        })
    })
});
