<?php namespace Visiosoft\MotorcycleModule\Status\Records;

use Anomaly\Streams\Platform\Model\EloquentModel;
use Visiosoft\MotorcycleModule\Status\StatusModel;
use Visiosoft\MotorcycleModule\Transport\TransportModel;

class RecordsModel extends EloquentModel
{
    protected $table = 'transport_status_records';
    public $timestamps = true;


    protected $fillable = [
        'transport_id',
        'status_id',
    ];

    protected $dates = [
        'created_at',
        'updated_at',
    ];


    // relation
    public function status()
    {
        return $this->belongsTo(StatusModel::class, 'status_id');
    }

    public function transport()
    {
        return $this->belongsTo(TransportModel::class, 'transport_id');
    }
}
