<?php namespace Visiosoft\MotorcycleModule\Product;

use Visiosoft\CatsModule\Category\CategoryModel;
use Visiosoft\MotorcycleModule\Product\Contract\ProductInterface;
use Anomaly\Streams\Platform\Model\Motorcycle\MotorcycleProductEntryModel;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Visiosoft\MotorcycleModule\Status\StatusModel;

class ProductModel extends MotorcycleProductEntryModel implements ProductInterface
{
    use HasFactory;

    public function cat1() {
        return $this->belongsTo(CategoryModel::class,'cat1_id');
    }
    public function cat2() {
        return $this->belongsTo(CategoryModel::class,'cat2_id');
    }
    public function statusModel(){
        return $this->belongsTo(StatusModel::class, 'status');
    }

    public function getImages(){
        $item_Photo = array();
        if ($this->files){
            foreach ($this->files as $image) {
                $item_Photo[] = url('files/' . $image->path());
            }
        }
        return $item_Photo;
    }
    protected static function newFactory()
    {
        return ProductFactory::new();
    }
}
