<?php namespace Visiosoft\MotorcycleModule\Listeners;

use Monolog\Handler\StreamHandler;
use Monolog\Logger;
use Visiosoft\MotorcycleModule\Transport\Event\TransportCreated;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Notification\MailTemplate;

class TransportCreatedAdminNotification
{

    private $template;

    public function __construct(
        TemplateRepositoryInterface $template
    )
    {
        $this->template = $template;
    }

    public function handle(TransportCreated $event)
    {
        $admins = $event->getAdmins();
        $transport = $event->getTransport();

        $mail_params = [
            'transport_id' => $transport->id,
            'transport_detail_url' => route('admin_transport_detail', ['id' => $transport->id]),
        ];


        foreach ($admins as $admin) {
            try {
                if ($template = $this->template->findBySlug('admin_transport_created')) {
                    $admin->notify(new MailTemplate($template->getTemplateForArray($mail_params)));
                }
            } catch (\Exception $e) {
                $log = new Logger('mail');
                $log->pushHandler(new StreamHandler(storage_path('logs/mail.log')), Logger::ERROR);
                $log->error($e->getMessage());
            }
        }

    }
}
