<?php namespace Visiosoft\MotorcycleModule\Address;

use Visiosoft\LocationModule\City\CityModel;
use Visiosoft\LocationModule\District\DistrictModel;
use Visiosoft\LocationModule\Neighborhood\NeighborhoodModel;
use Visiosoft\MotorcycleModule\Address\Contract\AddressInterface;
use Anomaly\Streams\Platform\Model\Motorcycle\MotorcycleAddressEntryModel;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class AddressModel extends MotorcycleAddressEntryModel implements AddressInterface
{
    use HasFactory;

    /**
     * @return AddressFactory
     */


    public function city(){
        return $this->belongsTo(CityModel::class,'city_id');
    }

    public function district(){
        return $this->belongsTo(DistrictModel::class, 'district_id');
    }


    public function neighborhood(){
        return $this->belongsTo(NeighborhoodModel::class, 'neighborhood_id');
    }

    public function getCityName(){
        return $this->city->name ;
    }
    public function getDistrictName(){
        return $this->district->name;
    }
    protected static function newFactory()
    {
        return AddressFactory::new();
    }
}
