<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleMotorcycleCreateStatusStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = false;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'status',
        'title_column' => 'id',
        'translatable' => true,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */


    protected  $fields = [
        'name' => [
            'type' => 'anomaly.field_type.text',
            'config' => [
                'default_value' => ''
            ]
        ]
    ];

    protected $assignments = [
        'name' => [
            'translatable' => true,
            'required' => true,
        ]
    ];

}
