<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleMotorcycleCreateTransportStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = false;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'transport',
        'title_column' => 'id',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */


    protected $fields = [
        'from' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\MotorcycleModule\Address\AddressModel::class,
                'mode' => 'lookup'
            ]
        ],
        'to' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\MotorcycleModule\Address\AddressModel::class,
                'mode' => 'lookup'
            ]
        ],
        'product' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\MotorcycleModule\Product\ProductModel::class,
                'mode' => 'lookup',
            ]
        ],
        'user' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\ConnectModule\User\UserModel::class,
            ]
        ],

    ];


    protected $assignments = [
        'from',
        'to',
        'product',
        'user',
    ];


}
