<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleMotorcycleCreateProductStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = true;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'product',
        'title_column' => 'id',
        'translatable' => false,
        'versionable' => false,
        'trashable' => false,
        'searchable' => false,
        'sortable' => false,
    ];

    protected $fields = [
        'cat1' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\CatsModule\Category\CategoryModel::class,
                'mode' => 'lookup'
            ]
        ],
        'cat2' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\CatsModule\Category\CategoryModel::class,
                'mode' => 'lookup'
            ]
        ],
        'status' => [
            'type' => 'anomaly.field_type.select',
        ],
        'desc' => [
            'type' => 'anomaly.field_type.textarea'
        ],
        'files' => [
            'type' => 'visiosoft.field_type.media',
            'config' => [
                'folders' => ["ads_documents"],
                'mode' => 'upload',
            ],
        ],
    ];


    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'cat1',
        'cat2',
        'status',
        'desc',
        'files'
    ];



}
