<?php namespace Visiosoft\MotorcycleModule\Transport;

use Visiosoft\MotorcycleModule\Address\AddressModel;
use Visiosoft\MotorcycleModule\Product\ProductModel;
use Visiosoft\MotorcycleModule\Transport\Contract\TransportInterface;
use Anomaly\Streams\Platform\Model\Motorcycle\MotorcycleTransportEntryModel;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class TransportModel extends MotorcycleTransportEntryModel implements TransportInterface
{
    use HasFactory;

    /**
     * @return TransportFactory
     */

    public function getFromCityName(){
        return $this->from->city->name;
    }

    public function  getFromDistrictName(){
        return $this->from->district->name;
    }

    public function getToCityName(){
        return $this->to->city->name;
    }

    public function getToDistrictName(){
        return $this->to->district->name;
    }

    public function getAddresses(){
        return ['from_city' => $this->getFromCityName(), 'from_district' =>  $this->getFromDistrictName() , 'to_city' => $this->getToCityName(), 'to_district' => $this->getToDistrictName()];
    }

    public function getProductCategories(){
        return ['cat1' => $this->product->cat1->name, 'cat2' => $this->product->cat2->name, 'status' => $this->product->statusmodel->name];
    }
    protected static function newFactory()
    {
        return TransportFactory::new();
    }
}
