<?php namespace Visiosoft\MotorcycleModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\MotorcycleModule\Status\Contract\StatusRepositoryInterface;
use Visiosoft\MotorcycleModule\Status\StatusRepository;
use Anomaly\Streams\Platform\Model\Motorcycle\MotorcycleStatusEntryModel;
use Visiosoft\MotorcycleModule\Status\StatusModel;
use Visiosoft\MotorcycleModule\PriceOffer\Contract\PriceOfferRepositoryInterface;
use Visiosoft\MotorcycleModule\PriceOffer\PriceOfferRepository;
use Anomaly\Streams\Platform\Model\Motorcycle\MotorcyclePriceOfferEntryModel;
use Visiosoft\MotorcycleModule\PriceOffer\PriceOfferModel;
use Visiosoft\MotorcycleModule\Transport\Contract\TransportRepositoryInterface;
use Visiosoft\MotorcycleModule\Transport\TransportRepository;
use Anomaly\Streams\Platform\Model\Motorcycle\MotorcycleTransportEntryModel;
use Visiosoft\MotorcycleModule\Transport\TransportModel;
use Visiosoft\MotorcycleModule\Address\Contract\AddressRepositoryInterface;
use Visiosoft\MotorcycleModule\Address\AddressRepository;
use Anomaly\Streams\Platform\Model\Motorcycle\MotorcycleAddressEntryModel;
use Visiosoft\MotorcycleModule\Address\AddressModel;
use Visiosoft\MotorcycleModule\Product\Contract\ProductRepositoryInterface;
use Visiosoft\MotorcycleModule\Product\ProductRepository;
use Anomaly\Streams\Platform\Model\Motorcycle\MotorcycleProductEntryModel;
use Visiosoft\MotorcycleModule\Product\ProductModel;
use Visiosoft\MotorcycleModule\Http\Controller\AddressController;
use Illuminate\Routing\Router;

class MotorcycleModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/motorcycle/status'           => 'Visiosoft\MotorcycleModule\Http\Controller\Admin\StatusController@index',
        'admin/motorcycle/status/create'    => 'Visiosoft\MotorcycleModule\Http\Controller\Admin\StatusController@create',
        'admin/motorcycle/status/edit/{id}' => 'Visiosoft\MotorcycleModule\Http\Controller\Admin\StatusController@edit',
        'admin/motorcycle/priceOffer'           => 'Visiosoft\MotorcycleModule\Http\Controller\Admin\PriceOfferController@index',
        'admin/motorcycle/priceOffer/create'    => 'Visiosoft\MotorcycleModule\Http\Controller\Admin\PriceOfferController@create',
        'admin/motorcycle/priceOffer/edit/{id}' => 'Visiosoft\MotorcycleModule\Http\Controller\Admin\PriceOfferController@edit',
        'admin/motorcycle/transport'           => 'Visiosoft\MotorcycleModule\Http\Controller\Admin\TransportController@index',
        'admin/motorcycle/transport/create'    => 'Visiosoft\MotorcycleModule\Http\Controller\Admin\TransportController@create',
        'admin/motorcycle/transport/edit/{id}' => 'Visiosoft\MotorcycleModule\Http\Controller\Admin\TransportController@edit',
        'admin/motorcycle/address'           => 'Visiosoft\MotorcycleModule\Http\Controller\Admin\AddressController@index',
        'admin/motorcycle/address/create'    => 'Visiosoft\MotorcycleModule\Http\Controller\Admin\AddressController@create',
        'admin/motorcycle/address/edit/{id}' => 'Visiosoft\MotorcycleModule\Http\Controller\Admin\AddressController@edit',
        'admin/motorcycle'           => 'Visiosoft\MotorcycleModule\Http\Controller\Admin\ProductController@index',
        'admin/motorcycle/create'    => 'Visiosoft\MotorcycleModule\Http\Controller\Admin\ProductController@create',
        'admin/motorcycle/edit/{id}' => 'Visiosoft\MotorcycleModule\Http\Controller\Admin\ProductController@edit',
        'admin/motorcycle'           => 'Visiosoft\MotorcycleModule\Http\Controller\Admin\TransportController@index',
        'admin/motorcycle/create'    => 'Visiosoft\MotorcycleModule\Http\Controller\Admin\TransportController@create',
        'admin/motorcycle/edit/{id}' => 'Visiosoft\MotorcycleModule\Http\Controller\Admin\TransportController@edit',


        'admin/motorcycle/view/{id}' => 'Visiosoft\MotorcycleModule\Http\Controller\Admin\TransportController@view',
        'admin/motorcycle/priceOffer/view/{id}' => 'Visiosoft\MotorcycleModule\Http\Controller\Admin\PriceOfferController@view',

        'transport' => [
            'as' => 'visiosoft.module.motorcycle::adress_create',
            'uses' => 'Visiosoft\MotorcycleModule\Http\Controller\TransportController@view'
        ],
        'transport_create' => [
            'as' => 'transport_create',
            'uses' => 'Visiosoft\MotorcycleModule\Http\Controller\TransportController@formcreate'
        ],

        'offer' => [
            'as' => 'visiosoft.module.motorcycle::adress_create',
            'uses' => 'Visiosoft\MotorcycleModule\Http\Controller\PriceOfferController@view',
            'middleware' => 'auth'
        ],
        'getoffer_create' => [
            'as' => 'getoffer_create',
            'uses' => 'Visiosoft\MotorcycleModule\Http\Controller\PriceOfferController@formcreate'
        ]
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\MotorcycleModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\MotorcycleModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        //Visiosoft\MotorcycleModule\Event\ExampleEvent::class => [
        //    Visiosoft\MotorcycleModule\Listener\ExampleListener::class,
        //],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\MotorcycleModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        MotorcycleStatusEntryModel::class => StatusModel::class,
        MotorcyclePriceOfferEntryModel::class => PriceOfferModel::class,
        MotorcycleTransportEntryModel::class => TransportModel::class,
        MotorcycleAddressEntryModel::class => AddressModel::class,
        MotorcycleProductEntryModel::class => ProductModel::class,
        MotorcycleTransportEntryModel::class => TransportModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        StatusRepositoryInterface::class => StatusRepository::class,
        PriceOfferRepositoryInterface::class => PriceOfferRepository::class,
        TransportRepositoryInterface::class => TransportRepository::class,
        AddressRepositoryInterface::class => AddressRepository::class,
        ProductRepositoryInterface::class => ProductRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
