<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleMotorcycleCreateAddressStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = false;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'address',
        'title_column' => 'id',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */

    protected  $fields = [
        'country_id' => [
            "type" => "anomaly.field_type.select",
            "config" => [
                "options" => [],
            ]
        ],
        'city_id' => [
            "type" => "anomaly.field_type.select",
            "config" => [
                "options" => [],
            ]
        ],
        'district_id' => [
            "type" => "anomaly.field_type.select",
            "config" => [
                "options" => [],
            ]
        ],
        'neighborhood_id' => [
            "type" => "anomaly.field_type.select",
            "config" => [
                "options" => [],
            ]
        ],
        'date' => [
            'type' => 'anomaly.field_type.datetime',
            'config' => [
                "default" => 'now',
                "mode" => "datetime",
                "picker" => true,
            ]
        ],
        'desc' => [
            'type' => 'anomaly.field_type.textarea'
        ]
    ];


    protected $assignments = [
        'country_id',
        'city_id',
        'district_id',
        'neighborhood_id',
        'date',
        'desc'

    ];

}
