<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleMotorcycleCreatePriceOfferStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = false;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'price_offer',
        'title_column' => 'id',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */

    protected $fields = [
        'product' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\MotorcycleModule\Product\ProductModel::class,
                'mode' => 'lookup',
            ]
        ],
        'delivery_point' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\MotorcycleModule\Address\AddressModel::class,
                'mode' => 'lookup'
            ]
        ],
        'user' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\ConnectModule\User\UserModel::class,
                'mode' => 'lookup'
            ]
        ]
    ];


    protected $assignments = [
        'product',
        'delivery_point',
        'user'

    ];

}
