<?php namespace Visiosoft\MotorcycleModule\Transport;

use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Visiosoft\MotorcycleModule\Status\Records\RecordsModel;
use Visiosoft\MotorcycleModule\Transport\Contract\TransportInterface;
use Anomaly\Streams\Platform\Model\Motorcycle\MotorcycleTransportEntryModel;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class TransportModel extends MotorcycleTransportEntryModel implements TransportInterface
{

    public function getFromCityName(){
        return $this->from->city->name;
    }

    public function  getFromDistrictName(){
        return $this->from->district->name;
    }

    public function getToCityName(){
        return $this->to->city->name;
    }

    public function getToDistrictName(){
        return $this->to->district->name;
    }

    public function getToDate(){
        return Carbon::create($this->to->date)->format('d.m.Y');
    }

    public function getFromDate(){
        return Carbon::create($this->from->date)->format('d.m.Y');
    }

    public function getAddresses(){
        return [
            'from_city' => $this->getFromCityName(),
            'from_district' =>  $this->getFromDistrictName() ,
            'from_date' => $this->getFromDate(),
            'to_city' => $this->getToCityName(),
            'to_district' => $this->getToDistrictName(),
            'to_date' => $this->getToDate()
        ];
    }
    public function getProduct(){
        $data = [
            'cat1' => $this->product->cat1->name,
            'cat2' => $this->product->cat2->name,
            'files' => $this->product->getImages(),
            'status' => $this->product->statusModel ? $this->product->statusModel->name : '-',
            'year' => $this->product->year,
            'km' => $this->product->km,
            'desc'=> $this->product->desc,
            'files' => $this->product->getImages(),
        ];

        return $data;
    }

    public function transportStatusRecords()
    {
        return $this->hasMany(RecordsModel::class, 'transport_id');
    }

    public function changeStatus($statusId)
    {
        $this->transportStatusRecords()->create(['status_id' => $statusId]);
    }

    public function getLastStatus(){
        $lastStatus = $this->transportStatusRecords()->orderBy('created_at', 'desc')->with(['status'])->first();
        if ($lastStatus){
            return $lastStatus->status->name;
        }
        return '-';
    }

    public function getStatus(){
        return $this->transportStatusRecords()->orderBy('created_at', 'desc')->with(['status'])->get();
    }
    public function getTransport()
    {
        $id = Auth::id();

        if (!$id) {
            return TransportModel::query();
        }

        return TransportModel::query()->where('user_id', $id)->whereNull('deleted_at');
    }
}
